﻿
const unknownStatus = 'وضعیت سرویس نامشخص می باشد';
let lastStatus = '';

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    $('#credit_place').text('');
    $('#ssplace').text(unknownStatus);
    if (mode_form) {
        transferData = initial_page(700, 500);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    load();
    setInterval(() => {
        reqsvr2("SmsMakerManagement.aspx/CheckPeriodically", "", function (data) {
            const $led = $('#container > footer > section > span.dot');
            let serviceStatusContent = unknownStatus;
            if (data.d) {
                $('#ssplace').closest('footer').addClass('stop_service');
                if (data.d[0] == '255') {
                    serviceStatusContent = 'دسترسی به بانک اطلاعاتی و جداول مقدور نیست';
                    $led.attr('class', 'dot bg-yellow');
                }
                else if (data.d[0] == 'Running') {
                    if (data.d[0] != lastStatus) {
                        refreshCredit();
                    }
                    serviceStatusContent = 'سرویس در حال اجرا می باشد';
                    $led.attr('class', 'dot bg-green');

                    if (data.d[2] != '-1') {
                        getCredit(data.d[2]);
                    }
                    $('#ssplace').closest('footer').removeClass('stop_service');
                }
                else if (data.d[0] == 'Stopped') {
                    serviceStatusContent = 'سرویس متوقف شده است';
                    $led.attr('class', 'dot bg-red');
                }
                else if (data.d[0] == '-1') {
                    serviceStatusContent = 'سرویس یافت نشد';
                    $led.attr('class', 'dot bg-red');
                }
                lastStatus = data.d[0];

                if ((data.d[1]) && (data.d[1] != '-1')) {
                    load_package_list(data.d[1]);
                }
            }
            $('#ssplace').text(serviceStatusContent);
        })
    }, 5000)
})

/////////////////////////////////////////////////////////
//// functions
/////////////////////////////////////////////////////////

function showMessengerErrors() {
    reqsvr("SmsMakerManagement.aspx/ShowMessengerErrors", "", function (data) {
        if (data.d) {
            if (data.d == -1) {
                alert_error("هیچ پیام‌رسان فعالی یافت نشد");
            } else {
                $('#tbody_messenger_errors').html(data.d);
                $('#get_errors_modal').modal({ backdrop: 'static', keyboard: false });
            }
        }
    });
}

function load() {
    reqsvr("SmsMakerManagement.aspx/GetPackageList", "", function (data) {
        if (data.d) {
            load_package_list(data.d);
        }
    });
}

function load_package_list(xml) {
    load_tbl_btn_copy(xml, 'package_list');

    $('#container table tbody tr td .glyphicon-pencil').each(function () {
        $(this).parent().prepend('<button onclick="view_result(this)" class="btn btn-default glyphicon glyphicon-eye-open" type="button" title="نمایش سوابق" ></button>');;
        $(this).closest("td").css("width", "100px");
    });
}

function new_package_list() {
    open_form_("../../page/SmsDepartment/NewSmsMakerForm.aspx", 'پکیج جدید', "-1&0", "load");
}

function edit_package_list(o) {
    var code = $(o).closest('tr').attr("code");
    if (code == "") return;
    const td_last_sent = document.querySelector(`#tbl_package_list>tbody>tr[code='${code}']>td[col_name=last_sent]`);
    if (!td_last_sent) return;
    open_form_("../../page/SmsDepartment/NewSmsMakerForm.aspx", 'ویرایش پکیج', `${code}&${td_last_sent.innerText.length}`, "load");
}
function view_result(o) {
    var code = $(o).closest('tr').attr("code");
    if (code == "") return;
    const title = $(o).closest('tr').find("td:eq(0)").text();
    open_form_("../../page/SmsDepartment/PackageResultForm.aspx", title, code + "&" + title, "load");
}
function copy_package_list(o) {
    var code = tbl_cur_row("#tbl_package_list");
    if (code == "" || code == undefined) return;
    show_input_alert('عنوان جدید', '',
        function (v) {
            reqsvr("copy", "code:" + code + ",name:'" + v + "'",
                function (data) {
                    if (data.d == "ok") {
                        load();
                    }
                    else
                        alert_error(data.d);
                });
        });


}
function delete_package_list(o) {
    var code = $(o).closest('tr').attr("code");
    if (code == "") return;
    confirm_alert(function () {
        reqsvr("SmsMakerManagement.aspx/RemovePackage", "id:" + code, function (data) {
            if (data.d == "ok") {
                load();
                alert_message("حذف انجام شد");
            }
            else {
                alert_error(data.d);
            }
        });
    }, function () { });
}
function refreshCredit() {
    reqsvr("QuickSmsForm.aspx/Credit", "", function (data) {
        if (data.d) {
            getCredit(data.d);
        }
    });
}
function getCredit(data) {
    let result = '';
    if (data) {
        const ans = data.split(':');
        if ((ans[0] == 'credit') && (ans[1].length > 0)) {
            result = `اعتبار حساب پیامک : ${(ans[1] * 1).toLocaleString()} ریال`;
        }
    }
    $('#credit_place').text(result);
}


