﻿
const container = document.getElementById('container');
const checkStatusBtn = document.getElementById('check-status');
const tableSection = document.getElementById('div_sent_list');
const slideToggleBtn = document.getElementById('slide-toggle');

const logSelector = document.getElementById('log-selector');
const personData = document.getElementById('person-data');
const summaryReportBtn = document.getElementById('summary-report');
const detailedReportBtn = document.getElementById('detailed-report');
const packageSelector = document.getElementById('package-selector');

const sendTypeSelector = document.getElementById('send-type-selector');
const personInfoSelector = document.getElementById('person-info-selector');

let range = 'all';
let isOpenExtended = false;
let isReporterReady = false;
const filter_section = '#filter > section ';
const onlyOnceDate = '';    //  "onlyOnceDate" is required to use "comFncSms" functions
let startDate = '';
let endDate = '';
let seleckedLog = '';
let userData = '';

reqsvr("SmsLogForm.aspx/ReceivePackageList", "", function (data) {
    if (data.d) {
        load_cb_not_select("#package-selector", data.d);
        isReporterReady = true;
    }
});

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    initial_date_ok = true;
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    refreshDates();
    createTable();

    const _setInterval = setInterval(() => {
        if (isReporterReady) {
            hideAllLogTools();
            clearInterval(_setInterval);
        }
    }, 200)
})

logSelector.addEventListener('change', (e) => {
    $('#person-info-selector').selectpicker('val', '');
    $('#send-type-selector').selectpicker('val', '');
    $('#package-selector').selectpicker('hide');
    personData.classList.add('invisible');
    hideAllLogTools();
    container.querySelectorAll(`${filter_section}> .${logSelector.value}`).forEach((item) => {
        item.classList.remove('hide');
    })
    userData = '';
    controlReporterBtns();
})

slideToggleBtn.addEventListener('click', (e) => {
    if (isReporterReady) {
        e.target.innerHTML = (isOpenExtended) ? '&#xf078;' : '&#xf077;';
        $("#filter").slideToggle();
        isOpenExtended = !isOpenExtended;
    } else {
        alert_error("گزارش ساز هنوز آماده نشده است، لطفا دوباره امتحان کنید");
    }
})

detailedReportBtn.addEventListener('click', (e) => {
    const query = getValidQuery();
    if (query) {
        reqsvr("SmsLogForm.aspx/GetDetailedReport", query, function (data) {
            if (data.d) {
                load_tbl(data.d, "sent_list");
                insertStatusIcons();
            }
        })
    }
})

summaryReportBtn.addEventListener('click', (e) => {
    const query = getValidQuery();
    if (query) {
        reqsvr("SmsLogForm.aspx/GetSummaryReport", query, function (data) {
            if (data.d) {
                alert_message(data.d, "خلاصه گزارش پیامهای ارسالی");
            }
        })
    }
})

personInfoSelector.addEventListener('change', (e) => {
    seleckedLog = e.currentTarget.value;
    personData.classList.remove('invisible');
    personData.value = '';
    userData = '';
    switch (seleckedLog) {
        case 'person-id':
            personData.placeholder = '';
            personData.maxLength = 20;
            break;
        case 'person-mobile':
            personData.placeholder = '09123456789';
            personData.maxLength = 11;
            break;
        default:
            break;
    }
    personData.focus();
    controlReporterBtns();
})

sendTypeSelector.addEventListener('change', (e) => {
    seleckedLog = e.currentTarget.value;
    $('#package-selector').selectpicker('deselectAll');
    switch (seleckedLog) {
        case 'total':
            $('#package-selector').selectpicker('hide');
            userData = [-1];
            break;
        case 'package':
            $('#package-selector').selectpicker('show');
            userData = '';
            break;
        case 'quick':
            $('#package-selector').selectpicker('hide');
            userData = [0];
            break;
        default:
            break;
    }
    controlReporterBtns();
})

personData.addEventListener('input', (e) => {
    userData = e.target.value;
    controlReporterBtns();
})

packageSelector.addEventListener('change', (e) => {
    userData = [...packageSelector.options].filter(option => option.selected).map(option => option.value);
    controlReporterBtns();
})

checkStatusBtn.addEventListener('click', (e) => {
    reqsvr("QuickSmsForm.aspx/GetStatus", "", function (data) {
        if (data.d) {
            showResult(data.d);
            createTable();
        }
    });
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function createTable() {
    const query = `range:\"${range}\"`;
    reqsvr("SmsLogForm.aspx/GetSmsList", query, function (data) {
        if (data.d) {
            load_tbl(data.d, "sent_list");
            insertStatusIcons();
        }
    })
}

function insertStatusIcons() {
    let _val = -1;
    let _title = '';
    let _iconName = '';
    let _className = '';
    if (tableSection.hasChildNodes) {
        tableSection.querySelectorAll('table tbody tr td:last-child').forEach((item) => {
            _val = item.innerText * 1;
            switch (_val) {
                case 0:
                    _title = 'نامشخص';
                    _iconName = 'exclamation';
                    _className = 'text-warning';
                    break;
                case 1:
                    _title = 'مخاطب دریافت نمود';
                    _iconName = 'check';
                    _className = 'text-success';
                    break;
                case 2:
                    _title = 'مخابرات ارسال نمود';
                    _iconName = 'check';
                    _className = 'text-info';
                    break;
                case 3:
                    _title = 'مشکل مخابراتی یا بلک لیست';
                    _iconName = 'minus-circle';
                    _className = 'text-danger';
                    break;
                default:
                    break;
            }
            item.title = _title;
            item.innerHTML = `<i class="fa fa-${_iconName}"></i><span class="hide">${_val}</span>`;
            item.classList.add(_className);
        })
    }
}

function hideAllLogTools() {
    const selectors = [...logSelector.options].filter(option => option.value).map(option => `${filter_section}> .${option.value}`).join(' , ');
    container.querySelectorAll(selectors).forEach((item) => {
        item.classList.add('hide');
    })
}

function getValidQuery() {
    document.querySelectorAll('.date').forEach((element) => {
        changedDate(element);
    })
    const checkAllDates = checkDates();
    if (checkAllDates) {
        let query = `type:\"${seleckedLog}\",`;
        query += `startDate:\"${startDate}\",`;
        query += `endDate:\"${endDate}\",`;
        query += `userData:\"${userData}\"`;
        return query;
    }
    alert_error("تاریخ ها به درستی وارد نشده است ");
    return checkAllDates;
}

function controlReporterBtns() {
    let result = true;
    if (seleckedLog == 'person-mobile') {
        if ((userData.length == 11) && (userData.startsWith('09'))) {
            result = false;
        }
    } else {
        result = (userData.length == 0);
    }
    summaryReportBtn.disabled = result;
    detailedReportBtn.disabled = result;
}

