﻿
const allExtensions = ['txt', 'xls', 'xlsx'];
const sampleTexts = ['', 'شماره مخاطبین :[نمونه 09123456789,09012345555]', 'ایمیل مخاطبین :[نمونه a@gmail.com,b@yahoo.com]', '', '', ''];

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    const transferData = initial_page(1000, 600);
    const accept = `.${allExtensions.join(",.")}`;
    $('#input-file').attr('accept', accept);
    parent.sel_prow = '';
    reqsvr("QuickSmsForm.aspx/ReceiveMessengerList", "", function (data) {
        if (data.d) {
            load_cb("#messenger_selector", data.d);
            selectMessenger($('#messenger_selector').val());
        }
    });
    $('#message-box').on('input', function () {
        const length = $(this).val().length;
        const counter = length ? `(${200 - length})` : '';
        $('#detail-count-down').text(counter);
    });
    $('#credit-sms').on('click', function () {
        reqsvr("QuickSmsForm.aspx/Credit", "", function (data) {
            if (data.d) {
                showResult(data.d);
            }
        });
    })
    $('#status-sms').on('click', function () {
        reqsvr("QuickSmsForm.aspx/GetStatus", "", function (data) {
            if (data.d) {
                showResult(data.d);
            }
        });
    })
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function send() {
    const message = $('#message-box').val().trim();
    $('#message-box').val(message);
    if (message.length == 0) {
        alert_error('متن پیام درج نشده است.');
        return;
    }
    const prow = (document.querySelector('#tbl_personel_list')) ? get_table_checked("#tbl_personel_list") : parent.sel_prow;
    const userInputData = $('#contact_data_input').val().trim();
    if ((userInputData.length == 0) && (prow.length == 0)) {
        alert_error('هیچ مخاطبی تعیین نشده است.');
        return;
    }
    switch ($('#messenger_selector').val()) {
        case '1':
            sendSms(prow, userInputData);
            break;
        case '2':
            sendEmail(prow, userInputData);
            break;
        case '3':
            sendBot(prow, 'telegram');
            break;
        case '4':
            sendBot(prow, 'bale');
            break;
        case '5':
            sendSanaco(prow);
            break;
        default:
            break;
    }
}

function selectMessenger(selectedValue) {
    if (selectedValue.length == 1) {
        $('#send-sms').removeClass('hide');
        const isSms = (selectedValue === '1');
        const noManualContact = (selectedValue === '3') || (selectedValue === '4') || (selectedValue === '5');
        $('#status-sms').toggleClass('hide', !isSms);
        $('#credit-sms').toggleClass('hide', !isSms);
        const contactSample = document.getElementById('contact_sample');
        contactSample.closest('section').classList.toggle('invisible', noManualContact);
        contactSample.innerText = sampleTexts[selectedValue];
    }
}

function sendSms(prow, userInputData) {
    const receiverNumber = getNumbers(userInputData);
    if ((receiverNumber.length == 0) && (prow.length == 0)) {
        alert_error('هیچ مخاطبی تعیین نشده است.');
        return;
    }

    let query = `receiverNumber:\"${receiverNumber.join()}\",`;
    query += `message:\"${$('#message-box').val().trim()}\",`;
    query += `prow:\"${prow}\"`;

    callServerMethod("QuickSmsForm.aspx/SendSms", query);
}

function sendEmail(prow, userInputData) {
    let query = `receiverEmail:\"${userInputData}\",`;
    query += `message:\"${$('#message-box').val().trim()}\",`;
    query += `prow:\"${prow}\"`;

    callServerMethod("QuickSmsForm.aspx/SendEmail", query);
}

function sendBot(prow, botKind) {
    let query = `botKind:\"${botKind}\",`;
    query += `message:\"${$('#message-box').val().trim()}\",`;
    query += `prow:\"${prow}\"`;

    callServerMethod("QuickSmsForm.aspx/SendBot", query);
}

function sendSanaco(prow) {
    let query = `message:\"${$('#message-box').val().trim()}\",`;
    query += `prow:\"${prow}\"`;

    callServerMethod("QuickSmsForm.aspx/SendSanaco", query);
}

function callServerMethod(methodName, query) {
    reqsvr(methodName, query, function (data) {
        if (data.d) {
            showResult(data.d[0]);
            var r = tbl_set_result2('#div_select_person', data.d[1]);
        }
    });
}

function getNumbers(input) {
    const a = input.split('');
    let b = '';
    let c = [];
    for (var i = 0; i < a.length; i++) {
        if (a[i] in ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']) {
            b += a[i];
            switch (b.length) {
                case 10:
                    if (b.startsWith('9')) {
                        c[c.length] = `0${b}`;
                        break;
                    } else {
                        continue;
                    }
                case 11:
                    if (b.startsWith('09')) {
                        c[c.length] = b;
                    }
                    break;
                default:
                    continue;
            }
        }
        b = '';
    }
    return c
}

///////////////////////////////////////////////////////
// upload file functions
///////////////////////////////////////////////////////

function showSelectedFileError(selectedFile) {
    let errorMessage = '';
    const fullName = selectedFile.name;
    const ext = fullName.substring(fullName.lastIndexOf('.') + 1).toLowerCase();
    if (selectedFile.size == 0) {
        errorMessage = 'فایل خالی است';
    } else if (selectedFile.size >= 10 * Math.pow(2, 20)) {
        errorMessage = 'اندازه فایل باید کمتر از ۱۰ مگابایت باشد';
    } else {
        if (!allExtensions.includes(ext)) {
            errorMessage = 'فایل انتخاب شده پشتیبانی نمی شود';
        }
    }
    return errorMessage;
}

function uploadFile(obj) {
    if (!obj.files[0]) return;
    wait_();
    let i = 0;
    const formData = new FormData();
    const errorMessage = showSelectedFileError(obj.files[i]);
    if (errorMessage) {
        alert_error(errorMessage);
        unwait_();
        return;
    }
    else {
        formData.append('file' + i, obj.files[i]);
        $.ajax({
            type: 'post',
            url: 'service/docUploader.ashx',
            data: formData,
            success: function (status) {
                if ((status.length) && (status != 'error')) {
                    const data_input = ($('#messenger_selector').val() === '1') ? getNumbers(status).join(',') : status;
                    $('#contact_data_input').val(data_input);
                }
                unwait_();
            },
            processData: false,
            contentType: false,
            error: function (request, status, error) {
                alert_error(request.responseText + "<br/>" + status + "<br/>" + error);
                unwait_();
            }
        });
    }
}
