﻿
let selectedCode;
let smsTableBody;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    if (mode_form) {
        transferData = initial_page(900, 600);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }

    if ((transferData.length > 0) && (transferData[0] * 1 > 0)) {
        const packageID = transferData[0] * 1;
        const title = transferData[1];
        let query = `id:${packageID}`;
        reqsvr("PackageResultForm.aspx/GetPackageRecords", query, function (data) {
            if (data.d) {
                fix_header_only = true;     //  Default tools (download Excel, print, search) should not be inserted for this table
                load_tbl(data.d, 'package_records');
                $("#tbl_package_records tr td").click(function () {
                    selectedCode = $(this).closest('tr').attr('code');
                    //  The print header parameters written by Mr.Poor
                    const printHeader = '{"headerc2":"' + title + '","headerc3":"زمان اجرا :' + $(this).closest('tr').find("td:eq(1)").text() + '"}';
                    loadSmsReport(selectedCode, printHeader);
                });
                const firstItem = document.querySelector('#tbl_package_records tbody tr:first-child td:last-child')
                if (firstItem) {
                    firstItem.click();
                }
            }
        });
    } else {
        close();
    }

    $('#container > article > header > div.btn-group').on('click', 'button', function (e) {
        const btn = $(this);
        if (btn.attr('name')) {
            if (smsTableBody) {
                smsTableBody.className = btn.attr('name');
            }
            $('#container > article > header > div.btn-group button.selected').removeClass('selected');
            btn.addClass('selected');
        }
    });
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function loadSmsReport(id, printHeader) {
    let query = `id:${id}`;
    reqsvr("PackageResultForm.aspx/GetSelectedPackageSms", query, function (data) {
        if (data.d) {
            load_tbl(data.d, 'sms_logs');
            //  The print header parameters written by Mr.Poor
            $('#div_sms_logs').attr('data_hf_print', printHeader);
            setTimeout(() => {
                smsTableBody = document.querySelector('#tbl_sms_logs > tbody');
                let tip;
                const counters = [0, 0, 0, 0];
                let str;
                let pos;
                smsTableBody.querySelectorAll('tr td span.fa').forEach((item) => {
                    str = item.className;
                    pos = str.indexOf('status-');
                    tip = str.slice(pos, pos + 8);
                    item.closest('tr').classList.add(tip);
                    item.classList.remove(tip);
                    counters[tip[7]]++;
                })
                refreshCounters(counters);
                $('#container > article > header > div.btn-group button:first').click();
            }, 200)
        }
    });
}

function refreshCounters(counters) {
    let sum = 0;
    const insertContent = (tip, value) => $(`#container > article > header > div.btn-group button[name='${tip}'] > span.badge`).text(value);
    for (var i = 0; i < 4; i++) {
        insertContent(`status-${i}`, counters[i]);
        sum += counters[i];
    }
    insertContent('all', sum);
}
