﻿
let startDate = '';
let endDate = '';
let onlyOnceDate = '';
let timeInterval = '';
let firstTime = '';
let lastTime = '';

let smsPatterns = '';
let oldPackageID;

let selectedWeekDays = [];
let selectedMonthDays = [];
const savedPackageData = {};


///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    initial_date_ok = true;
    let transferData;
    let opt = '';
    for (let i = 1; i <= 29; i++) {
        let j = `${(i < 10) ? 0 : ''}${i}`;
        opt += `<option value="${j}">${i}</option>`;
    }
    $('#month-days').prepend(opt);
    $('#month-days').selectpicker('refresh');
    if (mode_form) {
        transferData = initial_page(900, 700);
    } else {
        transferData = initial_tab();
    }

    initial_time_picker();
    refreshDates();

    setTimeout(() => {
        $('.clockpicker').clockpicker().find('input').change(
            function () {
                const time = this.value;
                if (time) {
                    const arr = time.split(':');
                    arr[0] *= 1;
                    arr[1] *= 1;
                    if (((arr[0] > 0) && (arr[0] < 23)) || ((arr[0] == 0) && (arr[1] >= 5)) || ((arr[0] == 23) && (arr[1] <= 55))) {
                        if (this.id == "f-time") {
                            firstTime = time;
                          //  changedFirstTime(time);
                        } else if (this.id == "l-time") {
                            lastTime = time;
                           // changedLastTime(time);
                        }
                        return;
                    }
                }
                if (this.id == "f-time") {
                    this.value = firstTime;
                } else if (this.id == "l-time") {
                    this.value = lastTime;
                }
                alert_error("محدوده زمانی مجاز ارسال پیام از 00:05 الی 23:55 می باشد");
            });
    }, 2000)

    hideAllPeriod();
    if (transferData[1] == 0) {
        $('#messenger_selector').prop('disabled', false);
        $('#messenger_selector').selectpicker('refresh');
    }

    oldPackageID = transferData[0] * 1;
    if (oldPackageID == -1) {
        $('#active').prop('checked', true);
        disableElement('only-once', false);
    }
    reqsvr("LoadData", "id:" + oldPackageID, function (data) {
        if (data.d) {
            load_cb("#messenger_selector", data.d[5]);
            setPatternSection(data.d[4]);
            if (oldPackageID > 0) {
                showOldPackage(data.d);
            }
        }
    });

    $('#week-days').on('change', function () {
        selectedWeekDays = $(this).val() || [];
    });

    $('#month-days').on('change', function () {
        selectedMonthDays = $(this).val() || [];
    });

})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function handlePeriodChange() {
    const selectedItem = document.getElementById('period-selector').value;
    hideAllPeriod();
    showHideLastTime();
    if (selectedItem == 'weekly') {
        disableElement('week-days', false);
    } else {
        if (selectedWeekDays.length) {
            selectedWeekDays = [];
            $('#week-days').selectpicker('val', selectedWeekDays);
        }
    }
    if (selectedItem == 'monthly') {
        disableElement('month-days', false);
    } else {
        if (selectedMonthDays.length) {
            selectedMonthDays = [];
            $('#month-days').selectpicker('val', selectedMonthDays);
        }
    }
    if (selectedItem == 'hourly') {
        disableElement('day-hours', false);
        timeInterval = $('#hourly-cycle').text();
    } else {
        timeInterval = '';
    }
    if (selectedItem == 'once') {
        disableElement('only-once', false);
    } else {
        onlyOnceDate = '';
        $('#only-once').val('');
    }
    updateFirstTimeLabel();
}

function openDraftList() {
    open_form_("../../page/SmsDepartment/DraftList.aspx", "لیست الگو", "", "receivePatternList");
}

function save() {

    if (check_force_error("#div_filter")) return;
    var data_filter = get_data_div("#div_filter");

    const assign = (document.querySelector('#chb_all:checked')) ? "all" : get_checked('#tbl_assign');
    const isValid = Validation();
    const isValuesChanged = isChangedValues();
    if ((isValid) && (isValuesChanged)) {
        if (assign.length == 0) {
            alert_error("هیچ انتصابی انجام نشده است");
            return;
        }

        if (($('#chance').prop('checked')) && ($('#period-selector').val() == 'hourly')) {
            lastTime = '23:55';
        }

        let query = `oldPackageID:${oldPackageID},`;
        query += `isActive:${$('#active').prop('checked') ? 1 : 0},`;
        query += `startDate:\"${startDate}\",`;
        query += `endDate:\"${endDate}\",`;
        query += `title:"${$('#Package-title').val().trim()}",`;
        query += `detail:\"${$('#Package-detail').val().trim()}\",`;
        query += `periodType:\"${$('#period-selector').val()}\",`;
        query += `schedule:\"${selectedMonthDays.join() || selectedWeekDays.join() || onlyOnceDate || timeInterval}\",`;
        query += `firstTime:\"${firstTime}\",`;
        query += `lastTime:\"${lastTime}\",`;
        query += `patternCode:${$('#pattern_list').val()},`;
        query += `assign:\"${assign}\",`;
        query += `unassign:\"${get_checked('#tbl_unassign')}\",`;
        query += `messengerKindId:${$('#messenger_selector').val()},`;
        query += `filter:\"${data_filter}\"`;

        reqsvr("SavePackage", query, function (data) {
            if (data.d) {
                switch (data.d) {
                    case "0":
                        break;
                    case "1":
                        call_fnc();
                        temporaryAlertSuccess();
                        close();
                        break;
                    default:
                        alert_error(data.d);
                        break;
                }
            }
        });
    }
}

function receivePatternList() {
    reqsvr("ReceivePatternList", "", function (data) {
        if (data.d) {
            setPatternSection(data.d);
        }
    });
}

function setPatternSection(patterns) {
    smsPatterns = patterns;
    const selectedOption = $('#pattern_list').val();
    load_cb("#pattern_list", patterns);
    $('#pattern_list').selectpicker('val', selectedOption);
    patternSelected();
}

function updateHourlyCycle() {
    const add0 = (n) => (n < 10) ? '0' + n : n;
    const value = $('#day-hours').val() * 15;
    const hour = Math.floor(value / 60);
    const minute = value % 60;
    timeInterval = `${add0(hour)}:${add0(minute)}`;
    $('#hourly-cycle').text(timeInterval);
}

function disableElement(selector, isDisable) {
    const element = document.getElementById(selector);
    if (!element) return;
    element.disabled = isDisable;
    if ($(element).hasClass('selectpicker')) {
        $(element).selectpicker('refresh');
    }

    const aside = element.closest('ASIDE');
    if (!aside) return;
    if (isDisable) {
        aside.classList.add('hide');
        element.removeAttribute('force');
    } else {
        aside.classList.remove('hide');
        if (selector != 'day-hours') {
            element.setAttribute('force', '1');
        }
    }
}

function patternSelected() {
    var selectedRow = search_xml(smsPatterns, $('#pattern_list').val());
    $("#div_detail").text($(selectedRow).find("detail").text());
    $("#div_message").text($(selectedRow).find("message").text());
    if ($('#pattern_list').val() != null)
        reqsvrS("load_item", "code:" + $('#pattern_list').val(), function (data) {
            $("#div_filter").html(data.d[0]);
        });

}

function temporaryAlertSuccess() {
    parent.Swal.fire({
        html: 'ذخیره شد',
        allowEscapeKey: false,
        allowOutsideClick: false,
        showConfirmButton: false,
        icon: 'success',
        timer: 1000,
        title: ''
    }).then((result) => {
        close();
    });
}

function hideAllPeriod() {
    disableElement('day-hours', true);
    disableElement('week-days', true);
    disableElement('month-days', true);
    disableElement('only-once', true);
}

function showHideLastTime() {
    const lTimePart = document.getElementById('last-time');
    if (($('#chance').prop('checked')) && ($('#period-selector').val() != 'hourly')) {
        lTimePart.classList.remove('invisible');
    } else {
        lTimePart.classList.add('invisible');
        lTimePart.querySelector('#l-time').value = '';
        lastTime = '';
    }
}

function isChangedValues(assign, unassign) {
    if (oldPackageID == -1) {
        return true;
    }

    let result = false;
    const _isActive = $('#active').prop('checked') ? 1 : 0;
    const _schedule = (selectedMonthDays.join() || selectedWeekDays.join() || onlyOnceDate || timeInterval);

    result = result || (savedPackageData.start_date != startDate);
    result = result || (savedPackageData.end_date != endDate);
    result = result || (savedPackageData.title != $('#Package-title').val().trim());
    result = result || (savedPackageData.detail != $('#Package-detail').val().trim());
    result = result || (savedPackageData.first_time != firstTime);
    result = result || (savedPackageData.last_time != lastTime);
    result = result || (savedPackageData.assign != assign);
    result = result || (savedPackageData.unassign != unassign);
    result = result || (savedPackageData.priod_type != $('#period-selector').val());
    result = result || (savedPackageData.messenger_pattern_id != $('#pattern_list').val());
    result = result || (savedPackageData.schedule != _schedule);
    result = result || (savedPackageData.is_active != _isActive);
    result = result || (savedPackageData.messenger_kind_id != $('#messenger_selector').val());
    return result;
}

function Validation() {
    const r = false;
    let isError = check_force_error('#tab_1');
    if (isError) return r;

    document.querySelectorAll('.date').forEach((element) => {
        changedDate(element);
    })

    const isCorrectDates = checkDates();
    if (isCorrectDates == false) {
        alert_error("تاریخ ها به درستی وارد نشده است ");
        return r;
    }

    if (firstTime.length == 0) {
        $('#f-time').addClass("red_border");
        alert_error("زمان اولین ارسال وارد نشده است ");
        return r;
    }
    $('#f-time').removeClass("red_border");
    $('#l-time').removeClass("red_border");

    if ($('#chance').prop('checked')) {
        if (lastTime.length > 0) {
            const l = Date.parse(`01/01/2020 ${lastTime}:00`);
            const f = Date.parse(`01/01/2020 ${firstTime}:00`);
            const dif_per_min = (l - f) / 60000;
            if (dif_per_min <= 0) {
                alert_error("آخرین فرصت ارسال به درستی وارد نشده است ");
                return r;
            }
            if (dif_per_min < 10) {
                alert_error(`آخرین فرصت ارسال باید از 10 دقیقه بیشتر باشد<br/>فاصله زمانی آخرین فرصت ارسال باید از 10 دقیقه بیشتر باشد`);
                return r;
            }
        } else {
            if ($('#period-selector').val() != 'hourly') {
                $('#l-time').addClass("red_border");
                alert_error("آخرین فرصت ارسال وارد نشده است ");
                return r;
            }
        }
    }
    return true;
}

function showOldPackage(oldData) {
    if (oldData) {
        const myxml = oldData[0];

        savedPackageData.schedule = search_xml_by_name(myxml, "schedule");
        const schedule = savedPackageData.schedule;

        savedPackageData.priod_type = search_xml_by_name(myxml, "priod_type");
        const priod = savedPackageData.priod_type;

        switch (priod) {
            case 'hourly':
                if ((schedule.length == 5) && (schedule.includes(':'))) {
                    const arr = schedule.split(':');
                    const h = arr[0] * 1;
                    const m = arr[1] * 1;
                    $('#day-hours').val((h * 60 + m) / 15)
                }
                updateHourlyCycle();
                disableElement('day-hours', false);
                break;
            case 'weekly':
                selectedWeekDays = schedule.split(',');
                $('#week-days').selectpicker('val', selectedWeekDays);
                disableElement('week-days', false);
                break;
            case 'monthly':
                selectedMonthDays = schedule.split(',');
                $('#month-days').selectpicker('val', selectedMonthDays);
                disableElement('month-days', false);
                break;
            default:
                onlyOnceDate = schedule;
                $('#only-once').val(schedule);
                disableElement('only-once', false);
                break;
        }
        $('#period-selector').selectpicker('val', priod);

        savedPackageData.start_date = search_xml_by_name(myxml, "start_date");
        startDate = savedPackageData.start_date;
        document.getElementById('start-date').value = startDate;

        savedPackageData.end_date = search_xml_by_name(myxml, "end_date");
        endDate = savedPackageData.end_date;
        document.getElementById('end-date').value = endDate;

        savedPackageData.is_active = search_xml_by_name(myxml, "is_active");
        $('#active').prop('checked', savedPackageData.is_active == 1);

        savedPackageData.title = search_xml_by_name(myxml, "title");
        $('#Package-title').val(savedPackageData.title);

        savedPackageData.messenger_kind_id = search_xml_by_name(myxml, "messenger_kind_id");
        $('#messenger_selector').selectpicker('val', savedPackageData.messenger_kind_id);

        savedPackageData.detail = search_xml_by_name(myxml, "detail");
        $('#Package-detail').val(savedPackageData.detail);

        savedPackageData.first_time = search_xml_by_name(myxml, "first_time");
        firstTime = savedPackageData.first_time;
        document.querySelector('#first-time .time').value = firstTime;

        savedPackageData.last_time = search_xml_by_name(myxml, "last_time");
        lastTime = savedPackageData.last_time;
        document.querySelector('#last-time .time').value = lastTime;
        if (lastTime) {
            $('#chance').click();
        }

        savedPackageData.messenger_pattern_id = search_xml_by_name(myxml, "messenger_pattern_id");
        $('#pattern_list').selectpicker('val', savedPackageData.messenger_pattern_id);
        patternSelected();
        load_tbl_chb(oldData[1], "assign");
        load_tbl_chb(oldData[2], "unassign");
        tbl_set_check('#tbl_assign', true);
        tbl_set_check('#tbl_unassign', true);
        $("#chb_all").prop('checked', oldData[3] == "1");

        savedPackageData.assign = search_xml_by_name(myxml, "assign");
        savedPackageData.unassign = search_xml_by_name(myxml, "unassign");
        updateFirstTimeLabel();


        set_data_div("#div_filter", search_xml_by_name(myxml, "filter"));

    }
}

function updateFirstTimeLabel() {
    const selected = $('#period-selector').val();
    const labelElement = document.querySelector('#first-time label');

    if (selected === 'hourly') {
        labelElement.innerHTML = 'ارسال از ساعت <i class="fa fa-info-circle text-warning" title="محدوده زمانی ارسال پیام تا 23:55 می باشد"></i> :';
    } else {
        labelElement.innerHTML = 'زمان اولین ارسال :';
    }
}
