﻿
const separator = '♣';    //  ♣ : alt+5
var edit_code = -1;
var field = [];
var type;

$(document).ready(function () {
    var ar = initial_page(1000, 750);
    edit_code = ar[0];
    type = "<option value='int'>عدد</option>";
    type = type + "<option value='text'>متن</option>";
    type = type + "<option value='date'>تاریخ</option>";
    type = type + "<option value='time'>ساعت</option>";
    type = type + "<option value='select'>انتخابی</option>";

    reqsvr("load", "code:" + edit_code, function (data) {
        load_cb_not_select_none("#cb_view", data.d[0]);

        if (data.d[2].length == 0) {
            $('#cb_view').selectpicker('val', '');
        }


        var xml = XMLparse(data.d[2]);
        var findrows = xml.find("mytable");
        $.each(findrows, function () {
            $('#tb_detail').val($(this).find('detail').text());
            $('#cb_view').val($(this).find('list_view_id').text());
            $('#tb_caption').val($(this).find('caption').text());
            $('#sms_box').val($(this).find('message').text());
            $("#formul_xml").val($(this).find('formul_xml').text().replaceAll("♥", "'"));


        });
        load_view_columns();
        load_filters(data.d[4]);
        if (data.d[5] == "1") {

            $("#div_columns").css("height", "unset");
            $("#div_view_columns").css("height", "unset");
            $("#tr_filter").addClass("hide");
            $("#btn_view_list").addClass("hide");
            $("#btn_group_list").addClass("hide");
        }
        else {
            initial_tagify();
        }
        max_f = parseInt(data.d[6]);
        run_smsBox();
    });

    $("#cb_view").on('change',
        function () {
            removeParameters();
            load_view_columns();
        });

});

function load_view_list() {
    var last_select = $('#cb_view').val();
    reqsvr("load_view_list", "", function (data) {

        load_cb("#cb_view", data.d);
        $('#cb_view').val(last_select);
    });

}

function initial_tagify() {

    var input = document.querySelector('#formul_xml'),
        tagify = new Tagify(input, {
            mode: 'mix',  // <--  Enable mixed-content
            pattern: /@|#/,  // <--  Text starting with @ or # (if single, String can be used here)
            tagTextProp: 'text',  // <-- the default property (from whitelist item) for the text to be rendered in a tag element.
            enforceWhitelist: true,
            whitelist: field.concat(parameter).map(function (item) { return typeof item == 'string' ? { value: item } : item }),
            keepInvalidTags: 0,
            duplicates: 1,
            dropdown: {
                enabled: 0,
                maxItems: 1000,
                position: 'text', // <-- render the suggestions list next to the typed text ("caret")
                mapValueTo: 'text', // <-- similar to above "tagTextProp" setting, but for the dropdown items
                highlightFirst: false  // automatically highlights first sugegstion item in the dropdown
            },
            transformTag: transformTag
        })
    tagify.on('input', function (e) {
        switch (e.detail.prefix) {
            case '@': tagify.settings.whitelist = field; break;
            case '#': initial_parameter(); tagify.settings.whitelist = parameter; break;
        }
        if (e.detail.value != undefined)
            if (e.detail.value.length > 1) tagify.dropdown.show.call(tagify, e.detail.value);
    })
    function transformTag(tagData) {
        switch (tagData.kind) {
            case "f": tagData.style = "--tag-bg:#a3ffb6"; break;
            case "p": tagData.style = "--tag-bg:#c5d9ff"; break;
        }
    }
}

function save() {

    const smsDraft = $("#sms_box").val();
    let selectedView = $("#cb_view").val();

    if (smsDraft.includes(separator)) {
        const viewItems = [];
        document.querySelectorAll('#tbl_view_columns > tbody > tr').forEach((tr) => viewItems.push(tr.getAttribute('code')));
        const smsParts = smsDraft.split(separator);
        for (let i = 1; i < smsParts.length; i += 2) {
            if (!viewItems.includes(smsParts[i])) {
                alert_error(`آیتم ${smsParts[i]} در ویو انتخابی وجود ندارد.`);
                return;
            }
        }
        if ((selectedView.length > 0) && (!viewItems.includes('prow'))) {
            alert_error('ویو انتخابی باید دارای آیتم prow باشد.');
            return;
        }
    } else {
        if (selectedView.length > 0) {
            //alert_error('درصورت عدم استفاده از آیتمهای ویو، از ویو خالی استفاده نمایید.');
            //return;
        }
    }


    var fil = '';
    $('#tbl_filter tbody tr').each(function () {
        fil = fil + '☻' + $(this).find("td").eq(0).html();
        fil = fil + '☺' + $(this).find("td").eq(1).find('input').val();
        fil = fil + '☺' + $(this).find("td").eq(2).find('input').val();
        fil = fil + '☺' + $(this).find("td").eq(3).find('select').val();
        fil = fil + '☺' + $(this).find("td").eq(4).find('input').val().replaceAll("'", "♥");
        fil = fil + '☺' + $(this).find("td").eq(5).find('input')[0].checked;
    });
    if (fil != "") fil = fil.slice(1);
    var formul = $("#formul_xml").val();
    if (formul == undefined) formul = "";
    formul = formul.replaceAll("'", "♥");
    reqsvr("save", "code:" + edit_code + ",message:'" + smsDraft + "',caption:'" + $("#tb_caption").val() + "',view_id:'" + selectedView + "',detail:'" + $("#tb_detail").val() + "', filter:'" + fil + "',formul_xml:'" + formul + "'",
        function (data) {

            if (data.d == "ok") {
                alert_success("ذخیره شد");
                call_fnc();
                close();
            }
            else
                alert_error(data.d);
        });
}

function load_view_columns() {

    reqsvrS("load_view_column", "view_id:'" + $("#cb_view").val() + "'", function (data) {
        load_tbl(data.d[0], 'view_columns');
        $("#tbl_view_columns").addClass("w-full");


        initial_field();
    });
}

function run_view() {
    open_form_('page/data/page_view_list.aspx', "لیست ویوها", "", "", "load_view_list");
}

function btn_group_list_click() {
    open_form_('../../page/report/page_report_group_list.aspx', "لیست دسته بندی ها", "", "", "");
}


function initial_field() {
    field = [];
    var fil = '';
    $('#tbl_view_columns tbody tr').each(function () {
        fil = $(this).find("td").eq(0).html();
        field.push({ value: fil, text: fil, kind: 'f' });
    });
}

//////////////////////////////////////////////////////////////////////////////////////////

let cursorPos = -1;
let smsBox;

function run_smsBox() {
    smsBox = document.getElementById('sms_box');
    smsBox.style.height = '100%';
    smsBox.style.width = '100%';
    smsBox.style.resize = 'none';

    smsBox.addEventListener('blur', (e) => {
        cursorPos = smsBox.selectionStart;
    })

    smsBox.addEventListener('beforeinput', (e) => {
        const item = e.target;
        const value = item.value;
        const strStart = value.substring(0, item.selectionStart);
        const strEnd = value.substring(item.selectionStart);
        const testCursorPos = (str) => (((str.split(separator).length) % 2) == 0);
        if ((testCursorPos(strStart)) || (testCursorPos(strEnd)) || ((e.data) && testCursorPos(e.data))) {
            e.preventDefault();
            return;
        }
        const isSelected = (item.selectionStart != item.selectionEnd);
        if (isSelected) {
            const subStr = value.substring(item.selectionStart, item.selectionEnd);
            if (testCursorPos(subStr)) {
                e.preventDefault();
            }
        } else {
            let offset = 0;
            let isDeletePress = false;
            switch (e.inputType) {
                case 'deleteContentBackward':
                    offset = 1;
                    isDeletePress = true;
                    break;
                case 'deleteContentForward':
                    isDeletePress = true;
                    break;
                default:
                    break;
            }
            const isMyChar = value[item.selectionStart - offset] == separator;
            if ((isDeletePress) && (isMyChar)) {
                e.preventDefault();
            }
        }
    })

    document.getElementById('div_view_columns').addEventListener('dblclick', (e) => {
        if (e.target.tagName != 'TD') return;
        const clickedItem = e.target.closest('tr');
        if (!clickedItem) return;
        const parameter = clickedItem.getAttribute('code');
        if (!parameter) return;
        if (cursorPos > -1) {
            $('#sms_box').highlightTextarea('destroy');
            insertParameter(parameter);
            cursorPos = -1;
            loadTextarea();
        } else {
            alert_error(`محل قرارگیری عبارت را با کلیک در متن پیام مشخص نمایید`)
        }
    });

    setTimeout(loadTextarea, 100);
}

function insertParameter(parameter) {
    const value = smsBox.value;
    const strStart = value.substring(0, cursorPos);
    const strEnd = value.substring(cursorPos);
    const testCursorPos = (str) => (((str.split(separator).length) % 2) == 1);
    if ((testCursorPos(strStart)) && (testCursorPos(strEnd))) {
        smsBox.value = `${strStart}${separator}${parameter}${separator}${strEnd}`;
    }
}

function loadTextarea() {
    $('#sms_box').highlightTextarea({
        words: {
            words: [`${separator}(.+?)${separator}`],
            debug: false
        }
    });
}

function removeParameters() {
    if (!smsBox.value.includes(separator)) return;
    $('#sms_box').highlightTextarea('destroy');
    const params = smsBox.value.split(separator);
    for (let i = 1; i < params.length; i += 2) {
        params[i] = '';
    }
    smsBox.value = params.join('');
}
function load_filters(d) {

    var xml = XMLparse(d);
    var findrows = xml.find("mytable");
    var headers = [];
    headers.push('<thead ><tr>');
    headers.push('<th  class="hide"><label>نام لاتین (بدون فاصله)</label></th>');
    headers.push('<th style="min-width:250px"><label>عنوان نمایشی</label></th>');
    headers.push('<th style="min-width:50px"><label>عرض</label></th>');
    headers.push('<th style="min-width:100px"><label>نوع</label></th>');
    headers.push('<th style="min-width:100px"><label>سایر</label></th>');
    headers.push('<th  class="hide"><label>ورود اجباری</label></th>');
    headers.push('<th style="min-width:20px; width:20px"><button  type="button" class="btn btn-info glyphicon glyphicon-plus"  onclick="fil_add(this)" ></button>  </th>');
    headers.push('</tr></thead>');
    var rows = [];
    rows.push('<tbody>');
    $(findrows).each(function () {

        rows.push('<tr row="' + $(this).find('row').text() + '">');
        rows.push('<td class="hide">' + $(this).find('name').text() + '</td>');
        rows.push('<td><input name="caption" class="w-full" type="text" value="' + $(this).find('caption').text() + '"/></td>');
        rows.push('<td><input name="width" class="w-full" type="number" value="' + $(this).find('width').text() + '"/></td>');
        var t = type.replace("value='" + $(this).find('type').text() + "'", "value='" + $(this).find('type').text() + "' selected ");
        rows.push('<td><select name="type" class="w-full" >' + t + '</select></td>');
        rows.push('<td><input name="options" class="w-full ltr" type="text" value="' + $(this).find('options').text().replaceAll("♥", "'") + '"/></td>');
        rows.push('<td  class="hide"><input name="force" type="checkbox" checked/></td>');
        rows.push('<td>');
        rows.push('<button type="button"  class="btn glyphicon glyphicon-trash red"  onclick="tr_remove(this)" ></button> ');
        rows.push('</td>');
        rows.push('</tr>');
    });
    rows.push('</tbody>');
    var top = '<table  id="tbl_filter"  class="table-bordered table-hover w-full ">';
    var bottom = '</table>';
    $('#div_filter').html(top + headers.join("") + rows.join("") + bottom);

    initial_parameter();

}
var max_f = 0;
function fil_add() {
    max_f = max_f + 1;
    var rows = '<tr row="-1">';
    rows = rows + '<td class="hide">f' + max_f + '</td>';
    rows = rows + '<td><input name="caption" class="w-full" type="text" value=""/></td>';
    rows = rows + '<td><input name="width" class="w-full" type="number" value="100"/></td>';
    rows = rows + '<td><select name="type" class="w-full" >' + type + ' </select></td>';
    rows = rows + '<td><input name="options" class="w-full ltr" type="text" value=""/></td>';
    rows = rows + '<td class="hide"><input name="force" type="checkbox" checked/></td>';
    rows = rows + '<td>';
    rows = rows + '<button  type="button" class="btn glyphicon glyphicon-trash red" onclick="tr_remove(this)" ></button> ';
    rows = rows + '</td>';
    rows = rows + '</tr>';
    $("#tbl_filter").find('tbody').append(rows);

}
function initial_parameter() {

    parameter = [];
    var fil = '';
    var na = '';
    $('#tbl_filter tbody tr').each(function () {
        fil = $(this).find("td").eq(0).html();
        na = $(this).find("td").eq(1).find('input').val();
        parameter.push({ value: fil, text: na, kind: 'p' });
    });

}