﻿
function showResult(data) {
    const ans = data.split(':');
    switch (ans[0]) {
        case 'deliveried':
            if (ans[1] == '0') {
                alert_message('وضعیت پیامهای ارسالی اخیر نامشخص است');
            } else if (ans[1] == '-1') {
                alert_message('تاییدیه ارسال تمام پیامهای اخیر دریافت شد');
            } else {
                alert_message(`تاییدیه ارسال ${ans[1]} پیام اخیر دریافت شد`);
            }
            break;
        case 'credit':
            alert_message(`اعتبار حساب : ${(ans[1] * 1).toLocaleString()} ریال`);
            break;
        case 'count':
            if (ans[1] != '0') {
                alert_message(`تعداد ${ans[1]} پیام ارسال شد`);
            }
            break;
        case 'error':
            if (ans[1] == 'NotSet') {
                alert_error('تنظیمات سامانه ارسال پیام تکمیل نیست');
            } else {
                alert_error('خطا در اعمال تنظیمات سامانه ارسال پیام');
            }
            break;
        case 'exception':
            alert_error(ans[1]);
            break;
        default:
            break;
    }
    unwait_();
}

function refreshDates() {
    const dateObjects = [];
    const allDate = document.querySelectorAll('.date');
    for (var i = 0; i < allDate.length; i++) {
        const el = allDate[i];
        dateObjects[i] = new PesianDate.persianCalendar(el.id, {
            onchange: function (pdate) {
                if (pdate) {
                    changedDate(el);
                    checkDates();
                }
            }
        })
    }
    initial_date_mask();
}

function changedDate(dateElement) {
    const date = dateElement.value;
    const id = dateElement.id;
    switch (id) {
        case 'start-date':
            startDate = date;
            break;

        case 'end-date':
            endDate = date;
            break;

        case 'only-once':
            onlyOnceDate = date;
            break;
    }
}

function checkDates() {
    let isCorrect = false;
    if (startDate && endDate) {
        const sentDate = onlyOnceDate ? onlyOnceDate : endDate;
        isCorrect = CMPDay(startDate, endDate, sentDate);
        if (isCorrect == false) {
            alert_error("ترتیب تاریخ ها رعایت نشده است ");
        }
    }
    return isCorrect;
}
