﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SmsLogForm.aspx.cs" Inherits="TimeWork.SmsLogForm" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/Treeview/Treeview.css" rel="stylesheet" />
    <link href="../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../style/Bootstrap/bootstrap.min.js"></script>
    <script src="../../style/alert/sweetalert.js"></script>
    <script src="../../style/Treeview/Treeview.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script>
    <script type="text/javascript" src="../../style/datatable/dataTables.min.js"></script>
    <script type="text/javascript" src="../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../style/mask/jquery.mask.min.js"></script>
    <script src="../../style/calendar/js-persian-cal.min.js"></script>
    <script src="../../script/fnc.js"></script>
    <script src="../../script/FncDate.js"></script>

    <%--Begin smsLog link--%>
    <link href="css/smsLog.css" rel="stylesheet" />
    <%--End smsLog link--%>
</head>
<body>
    <div id="container">
        <div id="filter">
            <section>
                <span class="log-items">گزارش براساس :</span>
                <select id="log-selector" class="selectpicker log-items" data-width="100%" title="نوع گزارش">
                    <option value="send-type">نحوه ارسال</option>
                    <option value="person-select">مخاطب</option>
                </select>
                
                <div class="send-type send-items">
                    <select id="send-type-selector" class="selectpicker" data-width="auto" title="نوع ارسال">
                        <option value="package">پیام ساز</option>
                        <option value="quick">پیامک سریع</option>
                        <option value="total">همه ارسالی ها</option>
                    </select>
                </div>
                <select id="package-selector" class="send-type selectpicker package-items" data-live-search="true" data-width="100%" 
                    title="عنوان پیام ساز" multiple="multiple" data-actions-box="true" data-size="7"></select>
                
                <div class="person-select person-items">
                    <select id="person-info-selector" class="selectpicker" data-width="auto" title="نحوه انتخاب">
                        <option value="person-id">شماره پرسنلی</option>
                        <option value="person-mobile">تلفن همراه</option>
                    </select>
                </div>
                <input id="person-data" type="tel" class="person-select form-control" autocomplete="off"/>
                
                <label class="start-date">
                    <span>از تاریخ : </span>
                    <input id="start-date" type="text" class="date form-control" />
                </label>

                <label class="end-date">
                    <span>تا تاریخ : </span>
                    <input id="end-date" type="text" class="date form-control" />
                </label>
                <div class="log-btns">
                    <div class="btn-group">
                        <button id="summary-report" type="button" class="btn btn-warning" disabled="disabled">چکیده گزارش</button>
                        <button id="detailed-report" type="button" class="btn btn-success" disabled="disabled">گزارش</button>
                    </div>
                </div>
            </section>
        </div>
        <nav class="btn-group">
            <button type="button" id="check-status" class="btn btn-info">بروزرسانی وضعیت پیامکها</button>
            <button type="button" id="slide-toggle" class="btn btn-primary fa">&#xf078;</button>
        </nav>
        <main>
            <div id="div_sent_list"></div>
        </main>
    </div>

    <%--Begin smsLog script--%>
    <script src="js/comFncSms.js"></script>
    <script src="js/smsLog.js"></script>
    <%--End smsLog script--%>
</body>
</html>
