﻿
const snapshotBtn = document.getElementById('btn_snapshot');
const snapshotBtn_loc = document.getElementById('btn_snapshot_loc');
const detailField = document.querySelector('.detail-field');
const video = document.getElementById('video');
const canvas = document.getElementById('canvas');
const operatingSystemType = getOperatingSystemType();

const positions = [];
const timeSpan = [];
let locationTracking = -1;
let stopReceivingLocation;
let videoStream;
let longitude;
let latitude;
let alarm = '';
let isCheckFake;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    let transferData;
    if (mode_form) {
        transferData = initial_page(800, 700);
    } else {
        transferData = initial_tab();
    }
    parent.win.maximize();
    if ((operatingSystemType == 'iOS') || (operatingSystemType == 'Android')) {
        locationTracking = navigator.geolocation.watchPosition(watchPositionCallback, errorPositionCallback);
         
    } else {
        close();
    }

    reqsvr('load', '', function (data) {
        if (data.d[0] == "1")
            $('#btn_snapshot').removeClass('hide');
        else
            $('#btn_snapshot').addClass('hide');
        if (data.d[1] == "1")
            $('#btn_snapshot_loc').removeClass('hide');
        else
            $('#btn_snapshot_loc').addClass('hide');
        isCheckFake = (data.d[2] == "1");

    });

})
  

snapshotBtn.addEventListener('click', (e) => {
    save_kind(1);
})


snapshotBtn_loc.addEventListener('click', (e) => {
    save_kind(2);
})

function save_kind(k) {
    $('#canvas').removeClass("hide");
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    canvas.getContext('2d').drawImage(video, 0, 0);

    const base64data = canvas.toDataURL('image/jpeg', 0.92);
    $('#btn_snapshot').prop('disabled', true);
    $('#btn_snapshot_loc').prop('disabled', true);
    $('#img_photo').attr('src', base64data);
    $('#div_picture').removeClass("hide");
    $('#div_camera').addClass("hide");
    save(base64data, k);
}
 

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

const errorPositionCallback = (error) => {
    let message;
    switch (error.code) {
        case error.PERMISSION_DENIED:
            message = "خطای دسترسی <br/>اجازه دسترسی به موقعیت جغرافیایی در تلفن همراه شما داده نشده است.<br/>لطفاً در قسمت تنظیمات گوشی به برنامه اجازه دسترسی به موقعیت مکانی داده شود.";
            break;
        case error.POSITION_UNAVAILABLE:
            message = "اطلاعات مکان در دسترس نیست.<br/>مجددا اقدام کنید.";
            break;
        case error.TIMEOUT:
            message = "محدوده زمانی برای دریافت موقعیت جغرافیایی پایان یافت.<br/>مجددا اقدام کنید.";
            break;
        case error.UNKNOWN_ERROR:
            message = "دریافت موقعیت جغرافیایی با خطا مواجه شده است";
            break;
    }
    alert_error(message);
};

const watchPositionCallback = (position) => {
    latitude = position.coords.latitude;
    longitude = position.coords.longitude;
    if (latitude && longitude) {
        if (timeSpan.length == 0) {
            timeSpan[0] = (new Date()).getTime();
            stopReceivingLocation = setTimeout(() => {
                validation(false);
            }, 10000)
        }
        positions[positions.length] = position;
        if (positions.length == 5) {
            timeSpan[1] = (new Date()).getTime();
            validation();
        }
    }
}

function validation(onTime = true) {
    navigator.geolocation.clearWatch(locationTracking);
    let isRealLocation;
    let errorType = '';
    try {
        if (positions.length == 0) {
            errorType = "عدم دریافت موقعیت";
            isRealLocation = false;
            return;
        } else {
            if (onTime) {
                clearTimeout(stopReceivingLocation);
                const elapsedTime = timeSpan[1] - timeSpan[0];
                if (elapsedTime < 2000) {
                    errorType = "خطای تکرار 5 موقعیت در بازه زمانی 2 ثانیه;";
                }
            }
            if (positions.length < 2) {
                errorType = `${errorType}خطای عدم دریافت 2 موقعیت در بازه 10 ثانیه;`;
            }
            for (let position of positions) {
                if ((position.coords.altitude == 0) || (position.coords.accuracy < 2)) {
                    errorType = `${errorType}مقدار ارتفاع: ${position.coords.altitude} , خطای دقت: ${position.coords.accuracy}`;
                    break;
                }
            }
        }
        isRealLocation = (isCheckFake == false) || (errorType.length == 0);
    } finally {
        alarm = errorType;
        if (isRealLocation) {
            positions.length = 0;
            timeSpan.length = 0;
            configCamera();
        } else {
            alert_error(`اطلاعات دریافتی از موقعیت جغرافیایی معتبر نمی باشد.<br/>لوکیشن دستگاه را خاموش و روشن کرده و دوباره پنجره ثبت تردد را باز کنید.`);
            close();
        }
    }
}



async function configCamera() {
    try {
        if ('mediaDevices' in navigator && 'getUserMedia' in navigator.mediaDevices) {
            await stopStream();
            const constraints = {
                video: {
                    facingMode: "user",
                },
            };
            videoStream = await navigator.mediaDevices.getUserMedia(constraints);
            video.srcObject = videoStream;
            $('#btn_snapshot').prop('disabled', false);
            $('#btn_snapshot_loc').prop('disabled', false);
        }
    } catch (err) {
        alert_error("اجازه دسترسی به دوربین داده نشده است.<br/>بعد از تایید دسترسی، مجددا اقدام کنید.");
    } finally {
        unwait_();
    }
}

async function stopStream() {
    try {
        if (videoStream && videoStream.getTracks) {
            await videoStream.getTracks().forEach((track) => {
                track.stop();
            });
        }
    } catch (err) {
        alert_error("توقف ویدئو استریم با خطا مواجه شده است" + '<br/>' + err + '<br/>' + err.message);   //  <==========
    }
}

function save(data_uri, k) {
    let query = `prow:\"${parent.uid ? parent.uid : 0}\",`;
    query += `pid:\"${parent.pid ? parent.pid : 0}\",`;
    query += `lat:\"${latitude}\",`;
    query += `lon:\"${longitude}\",`;
    query += `img:\"${data_uri}\",`;
    query += `other:\"<detail>${detailField.value}</detail><kind>${k}</kind><alarm>${alarm}</alarm>\"`;//    max alarm : 200 character
    reqsvr("../../ws_app.asmx/save_location", query, function (data) {
        if (data.d == "ok") {
            parent.Swal.fire({
                html: 'ثبت شد',
                allowEscapeKey: false,
                allowOutsideClick: false,
                showConfirmButton: false,
                icon: 'success',
                timer: 1000,
                title: ''
            }).then((result) => {
                close();
            });
        }
        else {
            alert_error(data.d);

        }
    });
}

function getOperatingSystemType() {
    let uA = navigator.userAgent || navigator.vendor || window.opera;
    if ((/iPad|iPhone|iPod/.test(uA) && !window.MSStream) || (uA.includes('Mac') && 'ontouchend' in document)) {
        return 'iOS';
    }

    let os = ['Windows', 'Android', 'Unix', 'Mac', 'Linux', 'BlackBerry'];
    for (let i = 0; i < os.length; i++) {
        if (new RegExp(os[i], 'i').test(uA)) {
            return os[i];
        }
    }
    return "unknown";
}
