﻿
<%@ WebHandler Language="C#" Class="docUploader" %>
using System;
using System.Web;
using System.IO;
using System.Globalization;
public class docUploader : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {

        context.Response.ContentType = "text/plain";
        try
        {
            string dirFullPath = HttpContext.Current.Server.MapPath("~/files/temp/");
            if (!Directory.Exists(dirFullPath))
            {
                Directory.CreateDirectory(dirFullPath);
            }

            string fullFileName = string.Empty;
            foreach (string s in context.Request.Files)
            {
                HttpPostedFile file = context.Request.Files[s];
                string fileName = file.FileName;

                if (!string.IsNullOrEmpty(fileName))
                {
                    if (s == "editedImage")
                    {
                        // The name of the edited image does not change
                        fullFileName = fileName;
                    }
                    else if (s == "scanImage")
                    {
                        // To specify the name of the scanned document
                        fullFileName = string.Format("{0}.jpg", DateTime.Now.Ticks);
                    }
                    else
                    {
                        // To specify the name of the document added (by uploading a file or camera photo)
                        fullFileName = string.Format("{0}{1}", DateTime.Now.Ticks, Path.GetExtension(fileName).ToLower());
                    }
                    file.SaveAs(string.Format("{0}{1}", dirFullPath, fullFileName));
                }
            }
            context.Response.Write(fullFileName);
        }
        catch (Exception ex)
        {
            bool result = ex.Message.Length == 0;
        }

    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

    /*    Mr.porhaji code
    public void ProcessRequest(HttpContext context)
    {

        context.Response.ContentType = "text/plain";
        try
        {
            string dirFullPath = HttpContext.Current.Server.MapPath("~/files/mail_attachment/");
            if (!System.IO.Directory.Exists(dirFullPath))
                System.IO.Directory.CreateDirectory(dirFullPath);

            string str_image = "";
            foreach (string s in context.Request.Files)
            {
                HttpPostedFile file = context.Request.Files[s];
                string fileName = file.FileName;
                string fileExtension = file.ContentType;

                if (!string.IsNullOrEmpty(fileName))
                {
                    fileExtension = Path.GetExtension(fileName);

                    string file_temp = (DateTime.UtcNow.ToFileTimeUtc() - 125911584000000000).ToString() + fileExtension;
                    str_image = str_image + "&" + file_temp + ":" + fileName;
                    string pathToSave_100 = HttpContext.Current.Server.MapPath("~/files/mail_attachment/") + file_temp;
                    file.SaveAs(pathToSave_100);
                }
            }
            //  database record update logic here  ()
            if (str_image != "") str_image = str_image.Remove(0, 1);
            context.Response.Write(str_image);
        }
        catch { }
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    */
}