
let canvas;
let mainImagePath;
let tempFileName;
let myCropper;
const imageEditButtons = document.querySelector('.image-edit-buttons');
const imageRepair = document.querySelector('#image-repair');

window.addEventListener('load', (e) => {
    const transferData = initial_page(700, 700);
    parent.win.maximize();

    mainImagePath = transferData[0];
    imageRepair.src = mainImagePath;
    tempFileName = mainImagePath.split('/').pop();

    imageEditButtons.querySelector('button[name=crop-btn]').classList.remove('clicked');
    imageEditButtons.querySelector('button[name=move-btn]').classList.add('clicked');

    myCropper = new Cropper(imageRepair, {
        /*
        // The initial aspect ratio of the crop box
        initialAspectRatio: NaN,
        // The aspect ratio of the crop box
        aspectRatio: NaN,
        // An object with the previous cropping result data
        data: null,
        // A selector for adding extra containers to preview
        preview: '',
        // Re-render the cropper when resize the window
        responsive: true,
        // Restore the cropped area after resize the window
        restore: true,
        // Check if the current image is a cross-origin image
        checkCrossOrigin: true,
        // Check the current image's Exif Orientation information
        checkOrientation: true,
        // Show the black modal
        modal: true,
        // Show the white modal to highlight the crop box
        highlight: true,
        // Show the grid background
        background: true,
         */
        // The view mode of the cropper
        viewMode: 2, // 0, 1, 2, 3
        // The dragging mode of the cropper
        dragMode: 'move', // 'crop', 'move' or 'none'
        // Enable to move the image
        //movable: false,
        // Show the dashed lines for guiding
        guides: false,
        // Show the center indicator for guiding
        center: false,
        // Enable to crop the image automatically when initialize
        autoCrop: false,
        // Define the percentage of automatic cropping area when initializes
        //autoCropArea: 0.5,
        // Enable to rotate the image
        rotatable: true,
        // Enable to scale the image
        scalable: true,
        // Enable to zoom the image
        zoomable: true,
        // Enable to zoom the image by dragging touch
        zoomOnTouch: false,
        // Enable to zoom the image by wheeling mouse
        zoomOnWheel: true,
        // Define zoom ratio when zoom the image by wheeling mouse
        wheelZoomRatio: 0.1,
        // Enable to move the crop box
        cropBoxMovable: true,
        // Enable to resize the crop box
        cropBoxResizable: true,
        // Toggle drag mode between "crop" and "move" when click twice on the cropper
        toggleDragModeOnDblclick: false,
        /*
        // Size limitation
        minCanvasWidth: 0,
        minCanvasHeight: 0,
        minCropBoxWidth: 0,
        minCropBoxHeight: 0,
        minContainerWidth: 200,
        minContainerHeight: 100,
        // Shortcuts of events
        ready: null,
        cropstart: null,
        cropmove: null,
        cropend: null,
        crop: null,
        zoom: null
     */
    });

    setTimeout(() => {
        myCropper.reset();
    }, 100);
    unwait_();
})

window.addEventListener('resize', (e) => {
    myCropper.reset();
})

imageEditButtons.addEventListener('click', (e) => {

    let clickedItem = e.target;
    if (clickedItem.tagName == 'DIV') {
        return;
    }
    if (clickedItem.tagName == 'I') {
        clickedItem = clickedItem.parentElement;
    }

    switch (clickedItem.name) {

        case 'save-image-btn':
            const fileExtension = tempFileName.split('.').pop();
            const imageType = (fileExtension != 'png') ? 'image/jpeg' : '';
            if (canvas) {
                canvas.toBlob(function (blob) {
                    wait_();
                    const formData = new FormData();
                    formData.append('editedImage', blob, tempFileName);
                    $.ajax({
                        type: 'post',
                        url: 'service/docUploader.ashx',
                        data: formData,
                        success: function (status) {
                            if (status != 'error') {
                                myCropper.destroy();
                                myCropper = null;
                                call_fnc();
                                close();
                            }
                            unwait_();
                        },
                        processData: false,
                        contentType: false,
                        error: function (request, status, error) {
                            alert_error(request.responseText + "<br/>" + status + "<br/>" + error);
                            unwait_();
                        }
                    });

                }, imageType, 0.92);
            }
            break;

        case 'reset-image-btn':
            imageEditButtons.classList.remove('cropped');
            myCropper.replace(mainImagePath);
            imageEditButtons.querySelectorAll('.flip').forEach((item) => {
                item.classList.remove('flip');
            })
            myCropper.reset();
            myCropper.clear();
            break;

        case 'move-btn':
            myCropper.setDragMode('move');
            imageEditButtons.querySelector('button[name=crop-btn]').classList.remove('clicked');
            clickedItem.classList.add('clicked');
            break;

        case 'crop-btn':
            myCropper.clear();
            myCropper.setDragMode('crop');
            imageEditButtons.querySelector('button[name=move-btn]').classList.remove('clicked');
            clickedItem.classList.add('clicked');
            break;

        case 'zoom-in-btn':
            myCropper.zoom(0.1);
            break;

        case 'zoom-out-btn':
            myCropper.zoom(-0.1);
            break;

        case 'rotate-left-btn':
            myCropper.rotate(-90);
            break;

        case 'rotate-right-btn':
            myCropper.rotate(90);
            break;

        case 'flip-horizontal-btn':
            clickedItem.classList.toggle('flip');
            myCropper.scaleX((clickedItem.classList.contains('flip')) ? -1 : 1);
            break;

        case 'flip-vertical-btn':
            clickedItem.classList.toggle('flip');
            myCropper.scaleY((clickedItem.classList.contains('flip')) ? -1 : 1);
            break;

        case 'ok-crop-btn':
            canvas = myCropper.getCroppedCanvas({
                fillColor: '#fff',
                imageSmoothingEnabled: true,
                imageSmoothingQuality: 'high',
                maxWidth: 4096,
                maxHeight: 4096
            });
            const base64data = canvas.toDataURL('image/jpeg', 0.92);
            myCropper.replace(base64data);
            myCropper.setDragMode('move');
            imageEditButtons.classList.add('cropped');
            imageEditButtons.querySelector('.clicked').classList.remove('clicked');
            imageEditButtons.querySelector('button[name=move-btn]').classList.add('clicked');
            break;

        default:
            break;
    }
})

///////////////////////////////////////////////////////
// dblclick event
///////////////////////////////////////////////////////

const dblclickZoomRatio = 1.2;
let clickCount = 0;
let firstClickTimer;

imageRepair.parentElement.addEventListener('click', (e) => {
    clickCount++;
    if (clickCount == 1) {
        firstClickTimer = setTimeout(() => {
            clickCount = 0;
        }, 400);
    } else if (clickCount == 2) {
        const canvasData = myCropper.getCanvasData();
        const ratio = dblclickZoomRatio * canvasData.width / canvasData.naturalWidth;
        clearTimeout(firstClickTimer);
        clickCount = 0;
        myCropper.zoomTo(ratio, {
            x: e.offsetX,
            y: e.offsetY,
        });
    }
})
