﻿
const previousPersonBtn = document.querySelector('.previous-person');
const personnelListCmb = document.querySelector('#person_list');
const nextPersonBtn = document.querySelector('.next-person');
const manageCategoriesBtn = document.querySelector('.manage-categories');

const removeDocumentBtn = document.querySelector('.group-deletion');
const downloadDocumentBtn = document.querySelector('.group-download');
const addNewDocumentBtn = document.querySelector('.add-new-document');

const selectAllItemsBtn = document.querySelector('.select-all-items');
const deselectAllItemsBtn = document.querySelector('.deselect-all-items');
const reverseSelectItemsBtn = document.querySelector('.reverse-select-items');

const customDisplay = document.querySelector('.custom-display');
const searchBox = customDisplay.querySelector('.document-search');
const viewSelector = customDisplay.querySelector('.view-selector');

const displayPart = document.querySelector('.detail-part');
const categoryPart = document.querySelector('.master-part');
const viewCookie = new CookieConnector('cardsView');

const selectedPersonDocuments = [];
const documentSelectedList = [];
let editedImageId = 0;

///////////////////////////////////////////////////////
//  events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {

    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }

    let personID = -1;
    if (transferData.length) {
        const value = parseInt(transferData[0]);
        if (value) {
            personID = value;
        }
    }

    if (('ontouchstart' in document.body) && ((window.outerWidth <= 768) || (window.outerHeight <= 500))) {
        displayPart.classList.add('grid-view');
    } else {
        const data = viewCookie.getData();
        if ((data) && (data === 'grid-view')) {
            displayPart.classList.add('grid-view');
            viewSelector.querySelector('input.grid-view').checked = true;
        } else {
            displayPart.classList.add('line-view');
        }
    }

    reqsvr("DocumentsViewForm.aspx/ReceivePersonNamesAndCategoryNames", "", function (data) {
        load_cb("#person_list", data.d[0]);
        loadCategory(data.d[1])

        let index = 0;
        if (personID >= 0) {
            const items = personnelListCmb.children;
            for (let i = 0; i < items.length; i++) {
                if (items[i].value * 1 == personID) {
                    index = i;
                    break;
                }
            }
        }
        personnelListCmb.selectedIndex = index;
        $('#person_list').selectpicker('render');
        receivePersonDocuments();
    });
})

categoryPart.addEventListener('click', (e) => {
    let clickedItem = e.target.closest('a');
    if (clickedItem) {
        if (clickedItem.classList.contains('root')) {
            changeSelectedCategory();
        } else {
            changeSelectedCategory(clickedItem.parentElement.value);
        }
    }
})

personnelListCmb.addEventListener('change', (e) => {
    receivePersonDocuments();
})

previousPersonBtn.addEventListener("click",(e)=>{
    selectClosestPerson(-1);
})

nextPersonBtn.addEventListener("click",(e)=>{
    selectClosestPerson(1);
})

manageCategoriesBtn.addEventListener("click", (e) => {
    open_form_('../../page/DocumentsArchive/page_paper_kind.aspx', 'لیست اسناد', "", "", "getCategoryNames");

})

removeDocumentBtn.addEventListener("click", (e) => {
    if (documentSelectedList.length) {
        const text = (documentSelectedList.length > 1) ? `آیا سندهای انتخاب شده(${documentSelectedList.length}) حذف شوند` : `آیا سند انتخاب شده حذف شود`;
        confirm_alert_msg(text,function () {
            const idList = documentSelectedList.map(item => item.docID).join();
            reqsvr("DocumentsViewForm.aspx/RemoveMultipleDocuments", "idList:'" + idList + "'", function (data) {
                if (data.d) {
                    let idList = data.d.split(',');
                    idList.forEach((id) => {
                        removeItemFromLists(id);
                        document.getElementById(id).remove();
                    })
                    setTimeout(() => {
                        clearSearchBox();
                        countCategoriesDocuments();
                        refreshViewElements();
                    }, 100);
                }
            })
        }, function () { });
    }
})

downloadDocumentBtn.addEventListener("click", (e) => {
    if (documentSelectedList.length) {
        const clickedItem = e.target;
        const idArray = documentSelectedList.filter((personnelDocument) => personnelDocument.isFileExists).map(item => item.docID);
        if (idArray.length) {
            const idList = idArray.join();
            reqsvr("DocumentsViewForm.aspx/DownloadMultipleDocuments", "idList:'" + idList + "'", function (data) {
                if (data.d) {
                    clickedItem.innerHTML += `<a download></a>`;
                    const aTag = clickedItem.querySelector('a');
                    const filePathList = data.d.split(',');
                    for (let i = 0; i < filePathList.length; i++) {
                        setTimeout((filePath) => {
                            aTag.href = `${filePath}`;
                            aTag.click();
                        }, (i + 1) * 100, filePathList[i])
                    }
                    aTag.remove();
                    deselectAllItems();
                    refreshViewElements();
                }
            })
        }
        if (idArray.length != documentSelectedList.length){
            alert_error(`${documentSelectedList.length - idArray.length} سند یافت نشد`);
        }
    }
})

addNewDocumentBtn.addEventListener('click', (e) => {
    const transferData = personnelListCmb.value + '&' + categoryPart.querySelector('.selected').parentElement.value;
    open_form_("page/DocumentsArchive/DocumentReceiveForm.aspx", 'سند جدید', transferData, '', 'UpdateDocumentInfo');
})

selectAllItemsBtn.addEventListener("click", (e) => {
    if (selectedPersonDocuments.length > 0) {
        let index;
        let checkbox;
        displayPart.querySelectorAll('.document-visible').forEach((documentVisible) => {
            if (!documentVisible.classList.contains('dont-match-search')) {
                checkbox = documentVisible.querySelector('input[type=checkbox]');
                if (!checkbox.checked) {
                    checkbox.checked = true;
                    index = selectedPersonDocuments.findIndex((item) => documentVisible.id == item.docID);
                    if (index >= 0) {
                        documentSelectedList.push(selectedPersonDocuments[index]);
                    }
                }
            }
        })
        refreshViewElements();
    }
})

deselectAllItemsBtn.addEventListener("click", (e) => {
    deselectAllItems();
    refreshViewElements();
})

reverseSelectItemsBtn.addEventListener("click", (e) => {
    if (selectedPersonDocuments.length > 0) {
        let index;
        let checkbox;
        displayPart.querySelectorAll('.document-visible').forEach((documentVisible) => {
            if (!documentVisible.classList.contains('dont-match-search')) {
                checkbox = documentVisible.querySelector('input[type=checkbox]');
                if (checkbox.checked) {
                    checkbox.checked = false;
                    index = documentSelectedList.findIndex((item) => documentVisible.id == item.docID);
                    if (index >= 0) {
                        documentSelectedList.splice(index, 1);
                    }
                } else {
                    checkbox.checked = true;
                    index = selectedPersonDocuments.findIndex((item) => documentVisible.id == item.docID);
                    if (index >= 0) {
                        documentSelectedList.push(selectedPersonDocuments[index]);
                    }
                }
            }
        })
        refreshViewElements();
    }
})

///////////////////////////////////////////////////////
//  main methods
///////////////////////////////////////////////////////

function refreshViewElements() {
    categoryPart.querySelector('.root i').innerText = selectedPersonDocuments.length ? `(${selectedPersonDocuments.length})` : '';
    let documentVisibleLength = countDocumentVisible();
    if (searchBox.value) {
        searchBox.disabled = false;
    } else {
        searchBox.disabled = documentVisibleLength == 0;
    }
    reverseSelectItemsBtn.disabled = documentVisibleLength == 0;
    if (displayPart.children.length) {
        displayPart.classList.remove('empty-msg');
        customDisplay.classList.remove('invisible');
        if (documentSelectedList.length) {
            selectAllItemsBtn.disabled = documentVisibleLength == documentSelectedList.length;
            deselectAllItemsBtn.disabled = false;
            removeDocumentBtn.disabled = false;
            downloadDocumentBtn.disabled = false;
        } else {
            selectAllItemsBtn.disabled = documentVisibleLength == 0;
            deselectAllItemsBtn.disabled = true;
            removeDocumentBtn.disabled = true;
            downloadDocumentBtn.disabled = true;
        }
        if ((displayPart.classList.contains('grid-view')) && (imageResizer.classList.contains('invisible'))) {
            imageResizer.classList.remove('invisible');
            resizeImages();
        }
    } else {
        customDisplay.classList.add('invisible');
        displayPart.classList.add('empty-msg');
        displayPart.innerText = 'هیچ موردی یافت نشد';
    }
    if (documentVisibleLength == 0) {
        imageResizer.classList.add('invisible');
        selectAllItemsBtn.disabled = true;
        deselectAllItemsBtn.disabled = true;
        removeDocumentBtn.disabled = true;
        downloadDocumentBtn.disabled = true;
        document.querySelector('.selected-documents-number').innerText = '';
    } else {
        document.querySelector('.selected-documents-number').innerText = `${documentVisibleLength} / ${documentSelectedList.length}`;
    }
}

function changeSelectedCategory(categoryCode) {
    if (categoryPart.querySelector('.selected')) {
        if (categoryPart.querySelector('.selected').parentElement.value == categoryCode) {
            return;
        }
        categoryPart.querySelector('.selected').classList.remove('selected');
    }
    displayPart.innerHTML = '';
    let selectedCategoryItems = [];
    if (categoryCode) {
        selectedCategoryItems = selectedPersonDocuments.filter((item) => item.categoryCode == categoryCode);
        categoryPart.querySelector(`li[value='${categoryCode}'] a`).classList.add('selected');
    } else {
        selectedCategoryItems = [...selectedPersonDocuments];
        categoryPart.querySelector('.root').classList.add('selected');
    }
    selectedCategoryItems.forEach((item) => {
        displayPart.append(createDocumentVisible(item));
    })
    documentSelectedList.length = 0;
    clearSearchBox();
    refreshViewElements();
}

function receivePersonDocuments(categoryCode) {
    selectedPersonDocuments.length = 0;
    reqsvr("DocumentsViewForm.aspx/ReceiveDocumentDetails", "personelID:" + personnelListCmb.value, function (data) {
        if (data.d) {
            let tblDocs = new ArrayCollection(data.d);
            for (i = 0; i < tblDocs.doc_id.length; i++) {
                let item = new PersonnelDocument(
                    tblDocs.doc_id[i],
                    personnelListCmb.value,
                    tblDocs.category_code[i],
                    tblDocs.category_name[i],
                    tblDocs.doc_title[i],
                    tblDocs.doc_detail[i],
                    tblDocs.user_id[i],
                    tblDocs.file_exists[i]==1,
                    tblDocs.image_path[i],
                    '', //  tblDocs.date_time[i]
                    tblDocs.file_extension[i]
                );
                selectedPersonDocuments.push(item);
            }
        }
        countCategoriesDocuments();
        changeSelectedCategory(categoryCode);
    });
}

function openEditForm(documentVisible) {
    if (selectedPersonDocuments.find((item) => documentVisible.id == item.docID).isFileExists) {
        editedImageId = documentVisible.querySelector('.card-header .card-img').src.includes(documentVisible.id) ? documentVisible.id : 0;
        open_form_("page/DocumentsArchive/DocumentReceiveForm.aspx", 'ویرایش اطلاعات سند', documentVisible.id, 'UpdateDocumentInfo');
    } else {
        alert_error('سند یافت نشد');
    }
}

function countCategoriesDocuments() {
    categoryPart.querySelectorAll('a').forEach((item) => {
        const value = selectedPersonDocuments.filter((personnelDocument) => personnelDocument.categoryCode == item.parentElement.value).length;
        item.querySelector('i').innerText = value ? `(${value})` : '';
    })
}

function getCategoryNames() {
    reqsvr("DocumentsViewForm.aspx/GetCategoryNames", "", function (data) {
        const categoryCode = categoryPart.querySelector('.root').classList.contains('selected') ? 0 : categoryPart.querySelector('.selected').parentElement.value;
        loadCategory(data.d)
        countCategoriesDocuments();
        if (categoryCode) {
            const list = categoryPart.querySelectorAll('a');
            for (let item of list) {
                if (item.parentElement.value == categoryCode) {
                    item.click();
                    return;
                }
            }
        }
        categoryPart.querySelector('.root').click();
    });
}

function loadCategory(data) {
    categoryPart.innerHTML = data;
    categoryPart.querySelector('li[value="0"] a').classList.add('root');
    categoryPart.querySelectorAll('a').forEach((item) => {
        const categoryName = item.innerText;
        item.innerHTML = `<label>${categoryName}</label><i></i></a>`;
    })

    $('#tree_section').treed();
    categoryPart.querySelectorAll('i.glyphicon-plus-sign').forEach((item) => {
        if (item.classList.contains('indicator')) {
            item.click();
        }
    })
}

///////////////////////////////////////////////////////
//  other methods
///////////////////////////////////////////////////////

function decreaseCategoryCounter(categoryCode) {
    const counter = categoryPart.querySelector(`li[value='${categoryCode}'] a i`);
    if (counter) {
        const text = counter.innerText;
        if (text.length) {
            const value = text.substring(1, text.length - 1) - 1;
            counter.innerText = value ? `(${value})` : '';
        }
    }
}

function UpdateDocumentInfo() {
    let delay = 0;
    if ((editedImageId) && (document.getElementById(editedImageId))) {
        document.getElementById(editedImageId).querySelector('.card-header .card-img').src = 'image/other.png';
        editedImageId = 0;
        delay = 1000;
    }
    setTimeout(() => {
        const categoryCode = categoryPart.querySelector('.root').classList.contains('selected') ? 0 : categoryPart.querySelector('.selected').parentElement.value;
        if (categoryCode) {
            categoryPart.querySelector('.selected').classList.remove('selected');
            receivePersonDocuments(categoryCode);
        } else {
            receivePersonDocuments();
        }
    }, delay);
}

function selectClosestPerson(step) {
    let index = personnelListCmb.selectedIndex + step;
    if ((index >= 0) && (index < personnelListCmb.children.length)) {
        personnelListCmb.selectedIndex = index;
        $('#person_list').selectpicker('render');
        receivePersonDocuments();
    }
}

function removeItemFromLists(itemID) {
    let index;
    index = selectedPersonDocuments.findIndex((item) => itemID == item.docID);
    if (index >= 0) {
        selectedPersonDocuments.splice(index, 1);
    }
    index = documentSelectedList.findIndex((item) => itemID == item.docID);
    if (index >= 0) {
        documentSelectedList.splice(index, 1);
    }
}

function countDocumentVisible() {
    let result = 0;
    for (let documentVisible of displayPart.children) {
        if (!documentVisible.classList.contains('dont-match-search')) {
            result++;
        }
    }
    return result
}

function deselectAllItems() {
    if (documentSelectedList.length) {
        documentSelectedList.forEach((item) => {
            document.getElementById(item.docID).querySelector('input[type=checkbox]').checked = false;
        })
        documentSelectedList.length = 0;
    }
}

///////////////////////////////////////////////////////
//  view files & images
///////////////////////////////////////////////////////

viewSelector.addEventListener('click', (e) => {
    let selectedView = '';
    if (e.target.tagName == 'INPUT') {
        if ((e.target.classList.contains('grid-view')) && (displayPart.classList.contains('line-view'))) {
            displayPart.classList.replace('line-view', 'grid-view');
            imageResizer.classList.remove('invisible');
            selectedView = 'grid-view';
            resizeImages();
        }
        if ((e.target.classList.contains('line-view')) && (displayPart.classList.contains('grid-view'))) {
            displayPart.classList.replace('grid-view', 'line-view');
            imageResizer.classList.add('invisible');
            selectedView = 'line-view';
        }
        if (selectedView) {
            deselectAllItems();
            clearSearchBox();
            refreshViewElements();
            viewCookie.setData(selectedView, 365);
        }
    }
})

///////////////////////////////////////////////////////
//  document-search
///////////////////////////////////////////////////////

searchBox.addEventListener('input', (e) => {
    if (e.target.value) {
        e.target.classList.add('searching');
    } else {
        e.target.classList.remove('searching');
    }
    const searchText = e.target.value.trim().toLowerCase();
    if (searchText === 'h.w') { //  By searching "h.w" the dimensions of the user's browser are received
        alert_message(`ow: ${window.outerWidth} , oh: ${window.outerHeight}<br/>iw: ${window.innerWidth} , ih: ${window.innerHeight}`);
        clearSearchBox();
        return;
    }
    const searchTextSplit = searchText.split(' ').filter(value => value !== ' ');
    const searchWords = [];
    for (let word of searchTextSplit) {
        if (!searchWords.find((item) => item.title === word)) {
            searchWords.push({
                title: word,
                count: searchTextSplit.filter(value => value === word).length,
                isFound: false,
            })
        }
    }

    displayPart.querySelectorAll('.document-visible').forEach((documentVisible) => {
        let itemText = documentVisible.querySelector('.title').innerText.trim().toLowerCase() + '☺';
        itemText += documentVisible.querySelector('.detail').innerText.trim().toLowerCase();
        for (let searchWord of searchWords) {
            searchWord.isFound = (itemText.split(searchWord.title).length - searchWord.count) > 0;
        }
        if (searchWords.every((searchWord) => searchWord.isFound)) {
            documentVisible.classList.remove('dont-match-search');
        } else {
            if (!documentVisible.querySelector('input[type=checkbox]').checked) {
                documentVisible.classList.add('dont-match-search');
            }
        }
    })
    refreshViewElements();
})

function clearSearchBox() {
    if (searchBox.value) {
        searchBox.value = '';
        displayPart.querySelectorAll('.dont-match-search').forEach((documentVisible) => {
            documentVisible.classList.remove('dont-match-search');
        })
        searchBox.classList.remove('searching');
    }
}

///////////////////////////////////////////////////////
//  click event documentVisible
///////////////////////////////////////////////////////

displayPart.addEventListener('click', (e) => {
    let clickedItem = e.target;
    const documentVisible = clickedItem.closest('.document-visible');
    if (documentVisible) {
        let index;
        switch (e.target.tagName) {
            case 'INPUT':
                if (clickedItem.checked) {
                    index = selectedPersonDocuments.findIndex((item) => documentVisible.id == item.docID);
                    if (index >= 0) {
                        documentSelectedList.push(selectedPersonDocuments[index]);
                    }

                } else {
                    index = documentSelectedList.findIndex((item) => documentVisible.id == item.docID);
                    if (index >= 0) {
                        documentSelectedList.splice(index, 1);
                    }
                }
                refreshViewElements();
                break;

            case 'I':
                clickedItem = clickedItem.parentElement;
            case 'BUTTON':
                if (clickedItem.classList.contains('downloadBtn')) {
                    if (selectedPersonDocuments.find((item) => documentVisible.id == item.docID).isFileExists) {
                        reqsvr("DocumentsViewForm.aspx/DownloadDocument", "id:" + documentVisible.id, function (data) {
                            if (data.d) {
                                clickedItem.innerHTML += `<a href="${data.d}" download></a>`;
                                clickedItem.querySelector('a').click();
                                clickedItem.querySelector('a').remove();
                            }
                        })
                    } else {
                        alert_error('سند یافت نشد');
                    }
                }
                if (clickedItem.classList.contains('editBtn')) {
                    openEditForm(documentVisible);
                }
                if (clickedItem.classList.contains('deleteBtn')) {
                    confirm_alert_msg('آیا سند حذف شود',function () {
                        reqsvr("DocumentsViewForm.aspx/RemoveDocument", "id:" + documentVisible.id, function (data) {
                            if (data.d) {
                                removeItemFromLists(documentVisible.id);
                                documentVisible.remove();
                                decreaseCategoryCounter(documentVisible.querySelector('.category').value);
                                setTimeout(refreshViewElements, 30);
                            }
                        })
                    }, function () { });
                }
                break;

            case 'IMG':
                // console.log('full size image');
                break;

            default:
                break;
        }
    }
})

///////////////////////////////////////////////////////
//  dblclick event documentVisible
///////////////////////////////////////////////////////

displayPart.addEventListener('dblclick', (e) => {
    const clickedItem = e.target.closest('DIV');
    const documentVisible = clickedItem.closest('.document-visible');
    if (documentVisible && clickedItem) {
        if ((clickedItem.classList.contains('card-header')) || (clickedItem.classList.contains('card-body'))) {
            openEditForm(documentVisible);
        }
    }
})

///////////////////////////////////////////////////////
//  range image-resizer
///////////////////////////////////////////////////////

const imageResizer = document.querySelector('div.image-resizer');
const rangeInput = imageResizer.querySelector('input');

imageResizer.addEventListener('click',(e)=>{
  if (e.target.tagName=='SPAN') {
    let min = rangeInput.min * 1;
    let max = rangeInput.max * 1;
    let value = rangeInput.value * 1;
    if (e.target.classList.contains('plus')) {
      if (min <= (value-1)) {
        rangeInput.value = value-1;
      }
    }
    if (e.target.classList.contains('minus')) {
      if (max >= value+1) {
        rangeInput.value = value+1;
      }
    }
    resizeImages();
  }
})

function findFirstImageDocument() {
    for (let documentVisible of displayPart.children) {
        if (!documentVisible.classList.contains('dont-match-search')) {
            return documentVisible;
        }
    }
}

rangeInput.addEventListener('input', (e) => {
    resizeImages();
})

{
    let countPerRow;
    function resizeImages() {
        const minCardWidth = (('ontouchstart' in document.body) && ((window.outerWidth <= 768) || (window.outerHeight <= 500))) ? 170 : 188;
        let documentVisible = findFirstImageDocument();
        if (documentVisible) {
            const myCookie = new CookieConnector('cardsCount');
            if (!countPerRow) {
                if (window.outerWidth <= 768) {
                    displayPart.style.gridTemplateColumns = `repeat(auto-fill , minmax(188px , 1fr))`;
                    return;
                } else {
                    const maxCardCount = Math.floor((displayPart.clientWidth - 20) / (2 + minCardWidth));   // 20 = padding-left + padding-right ;  2 = grid-gap * 2
                    rangeInput.min = Math.floor((maxCardCount + 1) / 2);
                    rangeInput.max = maxCardCount;
                    const data = myCookie.getData();
                    if ((data) && (data * 1) && ((data * 1) <= maxCardCount) && ((data * 1) >= (rangeInput.min * 1))) {
                        rangeInput.value = data * 1;
                    } else {
                        rangeInput.value = maxCardCount;
                    }
                }
            }
            let count = rangeInput.value * 1;
            if (countPerRow != count) {
                let minWidth = displayPart.clientWidth / (count + 0.5);
                minWidth = minWidth > minCardWidth ? minWidth : minCardWidth;
                displayPart.style.gridTemplateColumns = `repeat(auto-fill , minmax(${minWidth}px , 1fr))`;
                countPerRow = count;
                myCookie.setData(count, 365);
            }
        }
    }
}