﻿
///////////////////////////////////////////////////////
//      supported extensions list & icons
///////////////////////////////////////////////////////

const imageExtensions = ['bmp', 'png', 'jpg', 'jpeg', 'gif', 'svg', 'ico', 'tif'];
const nonImageExtensions = ['txt', 'xls', 'xlsx', 'doc', 'docx', 'pdf', 'ppt', 'ppsx', 'pptx'];

function getPathIcon(extension) {
    let icon;

    switch (extension) {
        case 'txt':
            icon = 'txt1.png';
            break;

        case 'xls':
        case 'xlsx':
            icon = 'excel1.png';
            break;

        case 'doc':
        case 'docx':
            icon = 'word1.png';
            break;

        case 'pdf':
            icon = 'pdf1.png';
            break;

        case 'ppt':
        case 'ppsx':
        case 'pptx':
            icon = 'power-point1.png';
            break;

        case 'notFoundDocument':
            icon = 'not-found1.png';
            break;

        default:
            icon = 'other.png';
            break;
    }

    return `image/${icon}`
}


///////////////////////////////////////////////////////
//      class PersonnelDocument
///////////////////////////////////////////////////////

class PersonnelDocument{
    constructor(docID, personelID, categoryCode, categoryName, docTitle, docDetail, userID, isFileExists, imagePath, dateTime, fileExtension) {
        this.docID = docID;
        this.personelID = personelID;
        this.categoryCode = categoryCode;
        this.categoryName = categoryName;
        this.docTitle = docTitle;
        this.docDetail = docDetail;
        this.userID = userID;
        this.isFileExists = isFileExists;
        this.imagePath = imagePath;
        this.dateTime = dateTime;
        this.fileExtension = fileExtension;
    }
}

function createDocumentVisible(personnelDocument) {

    const documentVisible = document.createElement('span');
    const cardHeader = document.createElement('div');
    const cardBody = document.createElement('div');
    const cardFooter = document.createElement('div');
    const imageTag = document.createElement('img');
    const titleTag = document.createElement('span');
    const detailTag = document.createElement('span');
    const categoryTag = document.createElement('li');
    const checkBoxTag = document.createElement('input');
    const editImgTag = document.createElement('button');
    const downloadTag = document.createElement('button');
    const deleteTag = document.createElement('button');

    documentVisible.className = 'document-visible card';
    cardHeader.className = 'card-header unselectable';
    cardBody.className = 'card-body';
    cardFooter.className = 'card-footer unselectable';
    imageTag.className = 'image card-img';
    titleTag.className = 'title';
    detailTag.className = 'detail';
    categoryTag.className = 'category small';
    checkBoxTag.className = 'checkBox';
    editImgTag.className = 'editBtn text-primary';
    downloadTag.className = 'downloadBtn text-success';
    deleteTag.className = 'deleteBtn text-danger';

    documentVisible.id = personnelDocument.docID;
    imageTag.src = personnelDocument.imagePath;
    titleTag.innerText = personnelDocument.docTitle;
    detailTag.innerText = personnelDocument.docDetail;
    detailTag.title = personnelDocument.docDetail;
    categoryTag.innerText = personnelDocument.categoryName;
    categoryTag.value = personnelDocument.categoryCode;

    checkBoxTag.type = 'checkbox';
    editImgTag.type = 'button';
    downloadTag.type = 'button';
    deleteTag.type = 'button';
    editImgTag.innerHTML = '<i class="glyphicon glyphicon-pencil" title="ویرایش"></i>';
    downloadTag.innerHTML = '<i class="glyphicon glyphicon-download-alt" title="دانلود"></i>';
    deleteTag.innerHTML = '<i class="glyphicon glyphicon-trash" title="حذف"></i>';

    if (!personnelDocument.isFileExists) {
        //downloadTag.disabled = true;
        //downloadTag.classList.add('invisible');
        cardHeader.title='سند یافت نشد'
    }

    cardHeader.appendChild(imageTag);

    cardBody.appendChild(titleTag);
    cardBody.appendChild(detailTag);
    cardBody.appendChild(categoryTag);

    cardFooter.appendChild(checkBoxTag);
    cardFooter.appendChild(editImgTag);
    cardFooter.appendChild(downloadTag);
    cardFooter.appendChild(deleteTag);

    documentVisible.appendChild(cardHeader);
    documentVisible.appendChild(cardBody);
    documentVisible.appendChild(cardFooter);

    return documentVisible;
}

///////////////////////////////////////////////////////
//      class ArrayCollection
///////////////////////////////////////////////////////

class ArrayCollection {
    constructor(xml) {
        let div = document.createElement('div');
        let _getFieldNames = (xmlElement) => {
            let result = false;
            if (xmlElement.childElementCount) {
                result = _getFieldNames(xmlElement.children[0]);
            } else {
                result = [];
                for (const item of xmlElement.parentElement.children) {
                    result.push(item.tagName.toLowerCase());
                }
            }
            return result;
        }
        let _xmlEdit = (xmlStr) => {
            let result = xmlStr;
            if (xmlStr.includes('/>')) {
                let parts = xmlStr.split('/>');
                for (let i = 0; i < parts.length - 1; i++) {
                    parts[i] = parts[i].trimEnd();
                    let index = parts[i].lastIndexOf('<');
                    let tag = parts[i].substring(index + 1);
                    parts[i] = parts[i] + '></' + tag;
                }
                result = parts.join('>');
            }
            return result;
        }
        div.innerHTML = _xmlEdit(xml);
        this._fieldNames = _getFieldNames(div);
        for (let field of this._fieldNames) {
            this[field] = [];
            div.querySelectorAll(field).forEach((item) => {
                this[field].push(item.innerText);
            })
        }
    }
}

///////////////////////////////////////////////////////
//      class CookieConnector
///////////////////////////////////////////////////////

const _setCookie = Symbol();
const _getCookie = Symbol();

class CookieConnector {
    constructor(name) {
        this.cookieName = name;
    }

    [_setCookie](name, value, daysToLive) {
        let cookie = name.trim() + "=" + encodeURIComponent(value);    // delete semicolons, commas, and whitespace ('g;h_1 2,32'=>'g%3Bh_1%202%2C32')

        if (typeof daysToLive === "number") {
            cookie += "; max-age=" + (daysToLive * 86400) + ";";   // convert day to seconds (24h * 60m * 60s)
            //cookie += "path=/; domain=sanacosoft.com" //  uncomment for the availability of cookie on all pages of my site
            document.cookie = cookie;
        }
    }

    [_getCookie](name) {
        const cookieArr = document.cookie.split(";");
        for (let item of cookieArr) {
            const cookiePair = item.split('=');

            if (name.trim() === cookiePair[0].trim()) {
                return decodeURIComponent(cookiePair[1]);   // return cookie value with semicolons, commas, and whitespace ('g%3Bh_1%202%2C32'=>'g;h_1 2,32')
            }
        }
        return null;    // return null if not found
    }

    clearCookie() {
        const value = this[_getCookie](this.cookieName);
        if (value) {
            this[_setCookie](this.cookieName, "", 0);
        }
    }
    setData(value, daysToLive) {
        if (value) {
            this.clearCookie();
            this[_setCookie](this.cookieName, value, daysToLive);
        }
    }
    getData() {
        let value = this[_getCookie](this.cookieName);
        if (!value) {
            value = null;
        }
        return value;
    }
}
