﻿
const personelNameLbl = document.querySelector('.personel-name');
const personelCodeLbl = document.querySelector('.personel-code');
const categoryList = document.getElementById('cb_section');
const saveBtn = document.querySelector('.save-btn');
const resetBtn = document.querySelector('.reset-btn');

const temporaryImageLocation = document.querySelector('.temporary-image');
const titleField = document.querySelector('.title-field');
const detailField = document.querySelector('.detail-field');
const receiveBtns = document.querySelector('.receive-btn');

const fileSelector = document.getElementById('input-file');
const selectFileBtn = document.getElementById('select-file-btn');
const cameraBtn = document.getElementById('camera-btn');
const scannerBtn = document.getElementById('scanner-btn');

let personelID;
let tempFileName;
let fileExtension;

let documentInfo = {};
const mobileMode = ('ontouchstart' in document.body) && ((window.outerWidth <= 700) || (window.outerHeight <= 500)) ? true : false;
const allExtensions = [...imageExtensions, ...nonImageExtensions];
const operatingSystemType = getOperatingSystemType();

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    const transferData = initial_page(650, 700);

    switch (transferData.length) {
        case 1:
            receiveBtns.remove();
            documentInfo.id = transferData[0];
            if (documentInfo.id) {
                reqsvr("DocumentReceiveForm.aspx/LoadFields", "id:" + documentInfo.id, function (data) {
                    // load_cb2("#cb_section", data.d[0]);

                    load_cb_tree("#cb_section", data.d[0]);

                    let tblDoc = new ArrayCollection(data.d[1]);
                    tblDoc._fieldNames.forEach((field) => {
                        if (tblDoc[field].length) {
                            documentInfo[field] = tblDoc[field][0];
                        }
                    })
                    personelNameLbl.innerText = documentInfo.personel_name;
                    personelCodeLbl.innerText = documentInfo.personel_id;
                    if (documentInfo.file_exists) {
                        if (data.d[2]) {
                            tempFileName = data.d[2];
                            createTemporaryImage('imageOld', tempFileName);
                        } else {
                            createTemporaryImage('nonImageOld', documentInfo.file_extension);
                        }
                    } else {
                        createTemporaryImage('notFoundDocument', 'notFoundDocument');
                    }
                    undoChanges();
                });
                saveBtn.addEventListener("click", (e) => {
                    saveChanges();
                })
                resetBtn.addEventListener("click", (e) => {
                    undoChanges();
                })
            }
            break;
        case 2:
            saveBtn.disabled = true;
            receiveBtns.classList.remove('hidden');
            reqsvr("DocumentReceiveForm.aspx/ReceiveCategoryNames", "", function (data) {
                // load_cb2("#cb_section", data.d);

                load_cb_tree("#cb_section", data.d);

                resetInputs();
                if ((transferData[1] * 1) > 0) {
                    $("#cb_section").select2('val', transferData[1]);
                    categoryList.title = $("#select2-chosen-1").text();
                } else {
                    $("#cb_section").select2('val', '');
                    categoryList.title = '';
                }
            });
            personelID = transferData[0];
            reqsvr("DocumentReceiveForm.aspx/ReceivePersonData", "code:" + personelID, function (data) {
                if (data.d) {
                    const splitName = data.d.split('☺');
                    personelNameLbl.innerText = splitName[0].trim();
                    personelCodeLbl.innerText = splitName[1].trim();
                }
                else {
                    alert_error('');
                    close();
                }
            })
            saveBtn.addEventListener("click", (e) => {
                saveNewFile();
            })
            resetBtn.addEventListener("click", (e) => {
                resetInputs();
            })
            fileSelector.accept = `.${allExtensions.join(",.")}`;
            if ((operatingSystemType == 'Android') || (operatingSystemType == 'Windows')) {
                cameraBtn.classList.remove('hidden');
            }
            if (mobileMode) {
                parent.win.maximize();
            } else {
                if (operatingSystemType == 'Windows') {
                    scannerBtn.classList.remove('hidden');
                }
            }
            createConverter();
            break;

        default:
            return;
            break;
    }
})

fileSelector.addEventListener('change', (e) => {
    uploadFile(e.currentTarget);
})

selectFileBtn.addEventListener('click', (e) => {
    fileSelector.value = '';
    fileSelector.click();
})

detailField.addEventListener('input', (e) => {
    countDownDetailCharacters();
})

///////////////////////////////////////////////////////
// common functions
///////////////////////////////////////////////////////

function getTempFilePath(fileName) {
    if (fileName) {
        return `../../files/temp/${fileName}`;
    }
}

function countDownDetailCharacters() {
    document.getElementById('detail-count-down').innerText = detailField.value.length ? `(${500 - detailField.value.length})` : '';
}

function temporaryAlertSuccess(isCloseWindow) {
    parent.Swal.fire({
        html: 'ذخیره شد',
        allowEscapeKey: false,
        allowOutsideClick: false,
        showConfirmButton: false,
        icon: 'success',
        timer: 1000,
        title: ''
    }).then((result) => {
        if (isCloseWindow) {
            deleteTempFile();
            close();
        }
    });
}

function createTemporaryImage(mode, data) {
    if (mode && data) {
        temporaryImageLocation.innerHTML = '';
        const divContainer = document.createElement('div');
        const sectionContainer = document.createElement('section');

        const span = document.createElement('span');
        divContainer.className = 'image-background';
        const img = document.createElement('img');
        img.alt = 'تصویر نمایش داده نمی شود';

        switch (mode) {
            case 'imageNew':
            case 'imageOld':

                img.src = getTempFilePath(data);

                if (mobileMode) {
                    divContainer.appendChild(img);
                } else {
                    const button = document.createElement('button');
                    button.className = 'btn btn-warning';
                    button.type = 'button';
                    button.innerHTML = '<i class="glyphicon glyphicon-pencil" title="ویرایش"></i>';
                    button.addEventListener('click', (e) => {
                        openImageEditing();
                    })
                    span.appendChild(button);

                    img.title = 'برای ویرایش تصویر دبل کلیک کنید';
                    img.addEventListener('dblclick', (e) => {
                        openImageEditing();
                    })
                    span.appendChild(img);
                    divContainer.appendChild(span);
                }
                temporaryImageLocation.appendChild(divContainer);
                //setTimeout(() => {
                //    temporaryImageLocation.querySelector('button').style.top = temporaryImageLocation.querySelector('img').offsetTop + 10 + 'px';
                //}, 100);
                break;

            case 'nonImageNew':
                img.src = getPathIcon(data);
                img.className = 'upload-msg';

                span.className = 'upload-msg';
                span.innerText = fileSelector.value.substring(fileSelector.value.lastIndexOf('\\') + 1);

                const progressDiv = document.createElement('div');
                progressDiv.className = 'progress';
                progressDiv.innerHTML = '<div class="progress-bar progress-bar-success progress-bar-striped"></div>';

                sectionContainer.appendChild(img);
                sectionContainer.appendChild(span);
                sectionContainer.appendChild(progressDiv);
                temporaryImageLocation.appendChild(sectionContainer);
                break;

            case 'nonImageOld':
                img.src = getPathIcon(data);
                sectionContainer.appendChild(img);
                temporaryImageLocation.appendChild(sectionContainer);
                break;

            case 'notFoundDocument':
                img.src = getPathIcon(data);
                sectionContainer.appendChild(img);
                temporaryImageLocation.appendChild(sectionContainer);
                break;

            default:
                temporaryImageLocation.innerHTML = '<i class="fa fa-file-text-o"></i><i class="fa fa-picture-o"></i>';
                break;
        }
    } else {
        temporaryImageLocation.innerHTML = '<i class="fa fa-file-text-o"></i><i class="fa fa-picture-o"></i>';
    }
}

function deleteTempFile() {
    if (tempFileName) {
        const query = `tempFileName:\"${tempFileName}\"`;
        reqsvrS("DocumentReceiveForm.aspx/DeleteTempFile", query, function () { });
    }
}

function form_closing() {
    deleteTempFile();
}

function getOperatingSystemType() {
    let uA = navigator.userAgent || navigator.vendor || window.opera;
    if ((/iPad|iPhone|iPod/.test(uA) && !window.MSStream) || (uA.includes('Mac') && 'ontouchend' in document)) {
        return 'iOS';
    }

    let os = ['Windows', 'Android', 'Unix', 'Mac', 'Linux', 'BlackBerry'];
    for (let i = 0; i < os.length; i++) {
        if (new RegExp(os[i], 'i').test(uA)) {
            return os[i];
        }
    }
    return "unknown";
}

///////////////////////////////////////////////////////
// upload file functions
///////////////////////////////////////////////////////

function showSelectedFileError(selectedFile) {
    let errorMessage = '';
    const fullName = selectedFile.name;
    const ext = fullName.substring(fullName.lastIndexOf('.') + 1).toLowerCase();
    if ((selectedFile.size > 0) && (selectedFile.size < 10 * Math.pow(2, 20))) {
        if (!allExtensions.includes(ext)) {
            errorMessage = 'فایل انتخاب شده پشتیبانی نمی شود';
        }
    } else {
        if (selectedFile.size == 0) {
            errorMessage = 'فایل خالی است';
        } else {
            errorMessage = 'اندازه فایل باید کمتر از ۱۰ مگابایت باشد';
        }
    }
    return errorMessage;
}

function uploadFile(obj) {
    if (!obj.files[0]) return;
    wait_();
    let i = 0;
    const formData = new FormData();
    const errorMessage = showSelectedFileError(obj.files[i]);
    if (errorMessage) {
        alert_error(errorMessage);
        unwait_();
        return;
    }
    else {
        formData.append('file' + i, obj.files[i]);
        $.ajax({
            type: 'post',
            url: 'service/docUploader.ashx',
            data: formData,
            success: function (status) {
                if (status != 'error') {
                    try {
                        deleteTempFile();
                        fileExtension = status.split('.')[1];
                        if (imageExtensions.includes(fileExtension)) {
                            createTemporaryImage('imageNew', status);
                            setConverterInput(status);
                        } else {
                            createTemporaryImage('nonImageNew', fileExtension);
                        }
                    }
                    catch (error) {
                        alert_error(error.message);
                    }
                    finally {
                        tempFileName = status;
                        saveBtn.disabled = false;
                    }
                }
                unwait_();
            },
            processData: false,
            contentType: false,
            error: function (request, status, error) {
                alert_error(request.responseText + "<br/>" + status + "<br/>" + error);
                unwait_();
            }
        });
    }
}

///////////////////////////////////////////////////////
// Document editing functions
///////////////////////////////////////////////////////

function saveChanges() {
    if (!documentInfo.file_exists) {
        alert_error('سند یافت نشد');
        undoChanges();
        //close();
        return;
    }
    titleField.value = titleField.value.trim();
    detailField.value = detailField.value.trim();
    if (titleField.value) {
        titleField.classList.remove('required-field');
        if ((documentInfo.category_code != categoryList.value) || (documentInfo.title != titleField.value) || (documentInfo.detail != detailField.value)) {
            let query = `documentID:${documentInfo.id},`;
            query += `categoryID:${categoryList.value},`;
            query += `title:\"${titleField.value}\",`;
            query += `detail:\"${detailField.value}\"`;
            reqsvr("DocumentReceiveForm.aspx/SaveDocumentChanges", query, function (data) {
                if (data.d) {
                    documentInfo.category_code = categoryList.value;
                    documentInfo.title = titleField.value;
                    documentInfo.detail = detailField.value;
                    call_fnc();
                    temporaryAlertSuccess(true);
                }
            });
        } else {
            deleteTempFile();
            close();
        }
    } else {
        titleField.classList.add('required-field');
        alert_error("لطفا قسمت های مشخص شده را تکمیل نمائید");
    }
}

function undoChanges() {
    $("#cb_section").select2('val', documentInfo.category_code);
    categoryList.title = $("#select2-chosen-1").text();
    titleField.value = documentInfo.title;
    detailField.value = documentInfo.detail;
    countDownDetailCharacters();
}

function openImageEditing() {
    if (!mobileMode) {
        open_form_("page/DocumentsArchive/ImageEditingForm.aspx", "ویرایش تصویر", getTempFilePath(tempFileName), 'useEditedImage');
    }
}

function useEditedImage() {
    if (documentInfo.id) {
        reqsvr("DocumentReceiveForm.aspx/SaveEditedImage", "documentID:" + documentInfo.id, function (data) {
            if (data.d) {
                temporaryImageLocation.querySelector('img').src = getTempFilePath(tempFileName);
                temporaryAlertSuccess(false);
                call_fnc();
            }
        });
    } else {
        temporaryImageLocation.querySelector('img').src = getTempFilePath(tempFileName);
        setConverterInput();
    }
}

///////////////////////////////////////////////////////
// add file functions
///////////////////////////////////////////////////////

function resetInputs() {
    createTemporaryImage();
    categoryList.classList.remove('required-field');
    titleField.classList.remove('required-field');
    titleField.value = '';
    detailField.value = '';
    fileSelector.value = '';
    countDownDetailCharacters();
    if (tempFileName) {
        deleteTempFile();
        tempFileName = '';
        saveBtn.disabled = true;
        lastTemp = '☺';
    }
}

function saveNewFile() {
    let valid = false;
    valid = validateInputs();
    if (valid) {
        let query = `personelID:${personelID},`;
        query += `categoryID:${categoryList.value},`;
        query += `title:\"${titleField.value}\",`;
        query += `detail:\"${detailField.value}\",`;
        query += `is_image:${imageExtensions.includes(fileExtension) ? 1 : 0},`;
        /// <==== insert data
        query += `tempFileName:\"${tempFileName}\"`;
        smartStorage(query);
    } else {
        alert_error('لطفا قسمت های مشخص شده را تکمیل نمائید');
    }
}

function validateInputs() {
    let result = true;
    titleField.value = titleField.value.trim();
    detailField.value = detailField.value.trim();

    if (categoryList.value) {
        categoryList.classList.remove('required-field');
        result = result && true;
    } else {
        categoryList.classList.add('required-field');
        result = false;
    }

    if (titleField.value) {
        titleField.classList.remove('required-field');
        result = result && true;
    } else {
        titleField.classList.add('required-field');
        result = false;
    }

    return result;
}

function addNewDocument(query) {
    reqsvr("DocumentReceiveForm.aspx/DocumentStorage", query, function (data) {
        if (data.d) {
            temporaryAlertSuccess(false);
            resetInputs();
        }
    });
}

///////////////////////////////////////////////////////
// Image conversion section
///////////////////////////////////////////////////////

let converter;
let lastTemp = '☺';
const imageHide = document.querySelector('#imge');
imageHide.src = getPathIcon(lastTemp);

function createConverter() {
    converter = new Cropper(imageHide, {
        // The view mode of the cropper
        viewMode: 2, // 0, 1, 2, 3
        // The dragging mode of the cropper
        dragMode: 'move', // 'crop', 'move' or 'none'
        // Enable to move the image
        movable: false,
        // Show the dashed lines for guiding
        guides: false,
        // Show the center indicator for guiding
        center: false,
        // Enable to crop the image automatically when initialize
        autoCrop: false,
        // Enable to rotate the image
        rotatable: false,
        // Enable to scale the image
        scalable: false,
        // Enable to zoom the image
        zoomable: false,
        // Enable to zoom the image by dragging touch
        zoomOnTouch: false,
        // Enable to zoom the image by wheeling mouse
        zoomOnWheel: false,
        // Enable to move the crop box
        cropBoxMovable: false,
        // Enable to resize the crop box
        cropBoxResizable: false,
        // Toggle drag mode between "crop" and "move" when click twice on the cropper
        toggleDragModeOnDblclick: false,
    });
}

function setConverterInput(imageName) {
    if (imageName) {
        converter.replace(getTempFilePath(imageName));
        lastTemp = imageName.split('.')[0];
    } else {
        lastTemp = '☺';
    }
}

function smartStorage(query) {
    if (tempFileName.includes(lastTemp)) {
        const canvas = converter.getCroppedCanvas({
            fillColor: '#ffffff',
            imageSmoothingEnabled: true,
            imageSmoothingQuality: 'high',
            maxWidth: 4096,
            maxHeight: 4096
        });
        if (canvas) {
            canvas.toBlob(function (blob) {
                wait_();
                const formData = new FormData();
                formData.append('editedImage', blob, `${lastTemp}.jpg`);
                $.ajax({
                    type: 'post',
                    url: 'service/docUploader.ashx',
                    data: formData,
                    success: function (status) {
                        if (status != 'error') {
                            addNewDocument(query);
                        }
                        unwait_();
                    },
                    processData: false,
                    contentType: false,
                    error: function (request, status, error) {
                        alert_error(request.responseText + "<br/>" + status + "<br/>" + error);
                        unwait_();
                    }
                });
            }, 'image/jpeg', 0.92);
        }
    } else {
        addNewDocument(query);
    }
}

///////////////////////////////////////////////////////
// camera functions
///////////////////////////////////////////////////////
cameraBtn.addEventListener('click', (e) => {
    if ((operatingSystemType == 'Android') || (operatingSystemType == 'Windows')) {
        open_form_("page/DocumentsArchive/DocumentReceiveCamera.aspx", "دوربین", operatingSystemType, 'getCameraImage');
    }
})

function getCameraImage(cameraTemp) {
    fileExtension = cameraTemp.split('.').pop();
    if (imageExtensions.includes(fileExtension)) {
        deleteTempFile();
        createTemporaryImage('imageNew', cameraTemp);
        setConverterInput(cameraTemp);
        tempFileName = cameraTemp;
        saveBtn.disabled = false;
    }
}
///////////////////////////////////////////////////////
// scanner functions
///////////////////////////////////////////////////////
scannerBtn.addEventListener('click', (e) => {
    if (!mobileMode) {
        open_form_("page/DocumentsArchive/DocumentReceiveScanner.aspx", "اسکنر", '', 'getScannerImage');
    }
})

function getScannerImage(scanImage) {
    fileExtension = scanImage.split('.').pop();
    deleteTempFile();
    createTemporaryImage('imageNew', scanImage);
    tempFileName = scanImage;
    saveBtn.disabled = false;
}
///////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////
