﻿
let operatingSystemType = 'نامشخص';
const cameraResolution = {};
let clickCount = 0;
let firstClickTimer;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    const transferData = initial_page(800, 700);
    if (transferData.length == 1) {
        operatingSystemType = transferData[0];
    } else {
        unwait_();
        alert_error(`امکان دسترسی به دوربین وجود ندارد.<br/>os:${operatingSystemType}`);
        close();
        return;
    }
    parent.win.maximize();
    configure();
})

document.getElementById('btn_snapshot').addEventListener('click', (e) => {
    // take snapshot and get image data
    Webcam.snap(function (data_uri) {
        $('#btn_snapshot').prop('disabled', true);
        $('#img_photo').attr('src', data_uri);
        $('#div_picture').removeClass("hide");
        $('#div_camera').addClass("hide");
        save(data_uri);
    });
})

document.getElementById('div_camera').addEventListener('click', (e) => {
    clickCount++;
    if (clickCount == 1) {
        firstClickTimer = setTimeout(() => {
            clickCount = 0;
        }, 1000);
    } else if (clickCount == 4) {
        clearTimeout(firstClickTimer);
        clickCount = 0;
        alert_message(`width: ${cameraResolution.width}<br>height:${cameraResolution.height}<br>os:${operatingSystemType}`);
    }
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

async function configure() {
    const stream = await navigator.mediaDevices.getUserMedia({ video: { width: 9999 } });    //  <========== higher resolution
    let { width, height } = stream.getTracks()[0].getSettings();
    cameraResolution.width = width;
    cameraResolution.height = height;
    await stream.getTracks()[0].stop();

    switch (operatingSystemType) {
        case 'Android':
            const isVertical = (width < height);
            const biggerSide = isVertical ? height : width;

            if (biggerSide >= 2000) {
                if (isVertical) {
                    height = biggerSide * 0.75;
                    width = height * 0.75;   //  Fixed the image stretching bug
                } else {
                    width = biggerSide * 0.75;
                    height = width * 0.75;   //  Fixed the image stretching bug
                }
            } else {
                alert_message('جهت استفاده از دوربین لطفا از قسمت ارسال سند اقدام کنید.');
                unwait_();
                return;
            }

            Webcam.set({
                width: width,
                height: height,

                image_format: 'jpeg',
                jpeg_quality: 90,

                constraints: {
                    facingMode: 'environment'
                }
            });
            break;

        case 'Windows':
            Webcam.set({
                width: width,
                height: height,

                image_format: 'jpeg',
                jpeg_quality: 90
            });
            break;

        default:
            unwait_();
            alert_error(`امکان دسترسی به دوربین وجود ندارد.<br/>os:${operatingSystemType}`);
            return;
    }

    Webcam.attach('#my_camera');
    $('#btn_snapshot').prop('disabled', false);
    unwait_();
}

function save(data_uri) {
    wait_();
    let formData = new FormData();
    formData.append('file', data_uri);

    $.ajax({
        type: 'post',
        url: 'service/cameraUploader.ashx',
        data: formData,
        success: function (response) {
            let json = $.parseJSON(response);
            if (json.message == "ok") {
                call_fnc("'" + json.path + "'");
            }
            else {
                alert_error(json.message);
            }
            Webcam.reset();
            unwait_();
            close();
        },
        processData: false,
        contentType: false,
        error: function (request, status, error) {
            alert_error(request.responseText + "<br/>" + status + "<br/>" + error);
            unwait_();
        }
    });
}

function form_closing() {
    Webcam.reset();
}
