﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DocumentsViewForm.aspx.cs" Inherits="TimeWork.DocumentsViewForm" EnableSessionState="true" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    
    <link href="../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../style/jquery-ui.css" rel="stylesheet" />
    <link href="../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="css/fonts/google_icons.css" rel="stylesheet" /> 
    <link href="../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../style/Treeview/Treeview.css" rel="stylesheet" />
    <link href="../../style/sanaco.css" rel="stylesheet" />

    <script src="../../script/jquery.min.js"></script> 
    <script src="../../script/jquery-ui.min.js"></script>
    <script src="../../style/Bootstrap/bootstrap.min.js"></script>
    <script src="../../style/alert/sweetalert.js"></script>  
    <script src="../../style/Treeview/Treeview.js"></script>
    <script src="../../style/select/bootstrap-select.js"></script> 
    <script src="../../script/fnc.js"></script>

    <%--Begin DocumentsArchive link--%>
    <link href="css/bootstrap-card.css" rel="stylesheet" />
    <link href="css/documentsViewForm.css" rel="stylesheet" />
    <%--End DocumentsArchive link--%>
</head>

<body>
    <form id="form1" runat="server">

        <div class="main-container">
            <header>
                <button type="button" class="previous-person btn btn-default" title="نفر قبلی"><i class="glyphicon glyphicon-chevron-right"></i></button>
                <select name="" id="person_list" class="selectpicker" data-width="300px" data-size="10" data-live-search="true"></select>
                <button type="button" class="next-person btn btn-default" title="نفر بعدی"><i class="glyphicon glyphicon-chevron-left"></i></button>
            </header>
            <nav>
                <div class="category-buttons">
                    <button type="button" title="مدیریت دسته بندیها" class="manage-categories btn btn-warning">لیست دسته بندیها</button>
                </div>
                <div class="custom-display invisible">
                    <input type="text" name="" id="" class="document-search form-control" placeholder="جستجو ..."/>
                    <div class="view-selector">
                        <input type="radio" class="fa fa-th grid-view" name="view" title="نمای کادری" />
                        <input type="radio" class="fa fa-align-justify line-view" checked="checked" name="view" title="نمای سطری" />
                    </div>
                </div>
                <div class="group-operation btn-group">
                    <button class="add-new-document btn btn-info" type="button" title="سند جدید">
                        <i class="glyphicon glyphicon-plus"></i>
                    </button>
                    <button class="group-download btn btn-success" title="دانلود گروهی" type="button">
                        <i class="glyphicon glyphicon-download-alt"></i>
                    </button>
                    <button class="group-deletion btn btn-danger" title="حذف گروهی" type="button">
                        <i class="glyphicon glyphicon-trash"></i>
                    </button>
                </div>
            </nav>
            <main>
                <section id="tree_section" class="master-part treeview unselectable"></section>
                <section class="detail-part"></section>
            </main>
            <footer>
                <div class="group-selection">
                    <div>
                        <div class="image-resizer invisible">
                            <span class="plus fa">&#xf067;</span>
                            <input type="range" name="" id=""/>
                            <span class="minus fa">&#xf068;</span>
                        </div>
                    </div>
                    <article class="selected-documents-number"></article>
                    <button type="button" title="انتخاب همه" class="select-all-items btn btn-primary">انتخاب همه</button>
                    <button type="button" title="هیچکدام" class="deselect-all-items btn btn-primary">هیچکدام</button>
                    <button type="button" title="برعکس" class="reverse-select-items btn btn-primary">برعکس</button>
                </div>
            </footer>
        </div>

    </form>

    <%--Begin DocumentsArchive script--%>
    <script src="js/documentStructure.js"></script>
    <script src="js/documentsViewForm.js"></script>
    <%--End DocumentsArchive script--%>
</body>
</html>
