﻿
let prevStatus = 0;
let sessionGuid = '';
let isPollingActive = false;
let intervalId = null;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    if (('ontouchstart' in document.body) && ((window.outerWidth <= 700) || (window.outerHeight <= 500))) {
        alert_error('در تلفن همراه از این صفحه نمی توان استفاده نمود');
        close();
        return;
    }

    $('#div_person_data').on('click', function (e) {
        const clickedItem = e.target;
        const clickedTD = clickedItem.closest('td');
        if (clickedTD) {
            const tr = clickedTD.parentElement;
            const img = tr.querySelector('img');
            $('#selected_person_photo').attr('src', img ? img.src : '');
            if (clickedItem.tagName === 'INPUT' && clickedItem.name === 'admin') {
                clickedItem.classList.toggle('changed');
            }
        }
    });

    sessionGuid = transferData[0];
    $('#selected_person_photo').attr('src', '');
    unwait_();
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function getDevicePrson() {
    deselectMainTable();
    $('#div_device_person').empty();
    const query = `sessionGuid:'${sessionGuid}'`;
    reqsvr("service/CommonZK.asmx/GetAllUsersFromDevice", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            $('#device_user_modal').modal({ backdrop: 'static', keyboard: false });
            setTimeout((msg) => load_tbl_chb(msg, "device_person"), 500, result.message);
        } else {
            alert_error(result.message);
        }
    });
}

function selectPerson() {
    deselectMainTable();
    open_form_('../../page/personnel/page_personnel_select.aspx', 'انتخاب افراد', "", "selectPerson_ok");
}

function getPrsonSelected() {
    const personList = getSelectedTableItems('device_person');
    if (personList.length > 0) {
        resetPageParams();
        let query = `sessionGuid:'${sessionGuid}',pids:[${personList.join(',')}]`;
        start_function(false);
        $('#prson_selected_btn').addClass('hide');
        $('#cancel_modal_btn').removeClass('hide').text('توقف');

        reqsvr("service/CommonZK.asmx/GetUsersDetails", query, function (data) {
            isPollingActive = false;
            const result = JSON.parse(data.d);
            if (result.success) {
                load_tbl_chb(result.message, "person_data");
                setupSearchableInputs();
                end_function();
            } else {
                alert_error(result.message);
                $('#select_person_btn').prop('disabled', false);
                $('#get_device_prson_btn').prop('disabled', false);
            }
            $('#cancel_modal_btn').addClass('hide');
            $('#prson_selected_btn').removeClass('hide');
            $('#device_user_modal').modal('hide');
        });

        isPollingActive = true;
        query = `sessionGuid:'${sessionGuid}'`;
        startPolling(() => reqsvr2("service/CommonZK.asmx/GetUsersDetailsCount", query, function (data) {
            if (data.d && data.d < personList.length) {
                let caption = `توقف ${data.d}/${personList.length}`;
                $('#cancel_modal_btn').text(caption);
            }
        }))
    }
}

function saveDB() {
    const updates = collectSelectedUserData();
    if (updates.length === 0) {
        alert_error("هیچ پرسنلی انتخاب نشده است");
        return;
    }

    const saveToDB = (shouldReplacePic) => {
        start_function(false);
        const query = `sessionGuid:'${sessionGuid}', updates:${JSON.stringify(updates)}, replacePersonnelPicture:${shouldReplacePic}`;
        reqsvr2("service/CommonZK.asmx/UpdateAndSaveToDatabase", query, function (data) {
            end_function();
            const result = JSON.parse(data.d);
            if (result.success) {
                tbl_set_result2('#div_person_data', result.details);
                alert_success(result.message);
            } else {
                alert_error(result.message);
            }
        });
    }

    confirm_alert_msg("آیا مایلید تصویر پرسنلی افراد جایگزین گردد؟", () => saveToDB(true), () => saveToDB(false))
}

function removeFromDevice() {
    const personList = getSelectedTableItems('person_data');
    if (personList.length === 0) {
        alert_error("هیچ پرسنلی انتخاب نشده است");
        return;
    }

    const deleteUsers = (query) => {
        start_function();
        reqsvr2("service/CommonZK.asmx/RemoveFromDevice", query, function (data) {
            isPollingActive = false; // متوقف کردن polling
            end_function();
            const result = JSON.parse(data.d);
            if (result.success) {
                if (result.message > 0) {
                    alert_success(`تعداد حذف شده: ${result.message}`);
                    tbl_set_result2('#div_person_data', result.details);
                } else {
                    alert_message("هیچ پرسنلی حذف نشد");
                }
            } else {
                alert_error(result.message);
            }
        });
        trackProgress(2000);     // --- شروع Polling برای دریافت وضعیت پیشرفت ---
    }

    confirm_alert_msg("آیا مایلید افراد انتخاب شده از دستگاه حذف شوند؟",
        () => deleteUsers(`sessionGuid:'${sessionGuid}',pids:[${personList.join(',')}]`),
        () => { });
}

function sendDevice() {
    const updates = collectSelectedUserData();
    if (updates.length === 0) {
        alert_error("هیچ پرسنلی انتخاب نشده است");
        return;
    }

    start_function();
    const query = `sessionGuid:'${sessionGuid}', updates:${JSON.stringify(updates)}`;
    reqsvr2("service/CommonZK.asmx/UpdateAndSendToDevice", query, function (data) {
        isPollingActive = false; // متوقف کردن polling
        end_function();
        const result = JSON.parse(data.d);
        if (result.success) {
            if (result.message > 0) {
                alert_success(`تعداد ارسال شده: ${result.message}`);
                tbl_set_result2('#div_person_data', result.details);
            } else {
                alert_message("هیچ پرسنلی ارسال نشد");
            }
        } else {
            alert_error(result.message);
        }
    });
    trackProgress(2000);     // --- شروع Polling برای دریافت وضعیت پیشرفت ---
}

function openOtherDevicesModal() {
    $('#div_other_device').empty();
    const updates = collectSelectedUserData();
    if (updates.length === 0) {
        alert_error("هیچ پرسنلی انتخاب نشده است");
        return;
    }

    const query = `sessionGuid:'${sessionGuid}', updates:${JSON.stringify(updates)}`;
    reqsvr("service/CommonZK.asmx/GetSimilarDeviceTable", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            $('#other_device_modal').modal({ backdrop: 'static', keyboard: false });
            setTimeout((msg) => load_tbl_chb(msg, "other_device"), 500, result.message);
        } else {
            alert_error(result.message);
        }
    });
}

function removeFromOtherDevice() {
    const selectedDevices = getSelectedTableItems('other_device');
    const selectedPids = getSelectedTableItems('person_data');
    if (selectedDevices.length === 0) {
        alert_error("هیچ دستگاهی انتخاب نشده است");
        return;
    }

    const query = `sessionGuid:'${sessionGuid}', pids:[${selectedPids.join(',')}], targetDeviceCodes:[${selectedDevices.join(',')}]`;
    confirm_alert_msg("آیا مایلید افراد از دستگاه‌های انتخاب شده حذف شوند؟",
        () => executeMultiDeviceOperation("service/CommonZK.asmx/RemoveFromSelectedDevices", query),
        () => { });
}

function sendOtherDevice() {
    const selectedDevices = getSelectedTableItems('other_device');
    const selectedPids = getSelectedTableItems('person_data');
    if (selectedDevices.length === 0) {
        alert_error("هیچ دستگاهی انتخاب نشده است");
        return;
    }

    const query = `sessionGuid:'${sessionGuid}', pids:[${selectedPids.join(',')}], targetDeviceCodes:[${selectedDevices.join(',')}]`;
    executeMultiDeviceOperation("service/CommonZK.asmx/SendToSelectedDevices", query);
}

function cancelModal() {
    cancelCommand();
    $('#device_user_modal').modal('hide');
}

function deselectMainTable() {
    $('#selected_person_photo').attr('src', '');
    parent.sel_prow = '';
    $('#div_person_data').find('table > tbody > tr.selectedtr').removeClass('selectedtr');
}

function selectPerson_ok() {
    if (parent.sel_prow.length > 0) {
        resetPageParams();
        start_function(false);
        const query = `sessionGuid:'${sessionGuid}',codes:'${parent.sel_prow}'`;
        reqsvr("service/CommonZK.asmx/GetPersonFromDB", query, function (data) {
            const result = JSON.parse(data.d);
            if (result.success) {
                load_tbl_chb(result.message, "person_data");
                setupSearchableInputs();
                end_function();
            } else {
                alert_error(result.message);
                $('#select_person_btn').prop('disabled', false);
                $('#get_device_prson_btn').prop('disabled', false);
            }
        });
    }
}

function getSelectedTableItems(tblName, checkboxName) {
    let tr;
    let trCode;
    let items = [];
    const tableBody = document.getElementById(`body_${tblName}`);
    if (tableBody && (tableBody.innerHTML.length > 0)) {
        let flag = (checkboxName == undefined);
        tableBody.querySelectorAll('tr>td:first-child>input:checked').forEach(
            (item) => {
                tr = item.closest('tr');
                if (checkboxName) {
                    flag = (tr.querySelector(`td>input[name='${checkboxName}'].changed`) != undefined);
                }
                if (flag) {
                    trCode = tr.getAttribute('code');
                    items.push(trCode)
                }
            })
    }
    return items;
}

function collectSelectedUserData() {
    const updates = [];
    const tableBody = document.getElementById(`body_person_data`);
    if (tableBody && (tableBody.innerHTML.length > 0)) {
        tableBody.querySelectorAll('tr>td:first-child>input:checked').forEach(
            (item) => {
                const tr = item.closest('tr');
                const pid = tr.getAttribute('code');
                const name = tr.querySelector('input[name="person_name"]').value;
                const password = tr.querySelector('input[name="password"]').value;
                const card = tr.querySelector('input[name="card"]').value;
                const isAdmin = tr.querySelector('input[name="admin"]').checked;
                updates.push({
                    pid: pid,
                    name: name,
                    password: password,
                    cardNumber: card,
                    privilege: isAdmin ? 3 : 0
                });
            })
    }
    return updates;
}

function resetPageParams() {
    $('#div_person_data').text('');
    $('#save_db_btn').prop('disabled', true);
    $('#remove_from_device_btn').prop('disabled', true);
    $('#send_device_btn').prop('disabled', true);
    $('#open_other_devices_modal_btn').prop('disabled', true);
}

function end_function() {
    $('#cancel_btn').addClass('hide');
    document.querySelectorAll('.op').forEach((btnCmd) => btnCmd.disabled = false);
}

function start_function(isShow_cancelBtn = true) {
    if (isShow_cancelBtn) {
        $('#cancel_btn').removeClass('hide');
    }
    document.querySelectorAll('.op').forEach((btnCmd) => btnCmd.disabled = true);
}

function cancelCommand() {
    const query = `sessionGuid:'${sessionGuid}'`;
    reqsvr("service/CommonZK.asmx/CancelCommand", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            alert_message(result.message);
        }
    });
}

function startPolling(fetchFunction, interval = 1000) {
    stopPolling();
    intervalId = setInterval(() => {
        if (isPollingActive) {
            fetchFunction();
        } else {
            stopPolling();
        }
    }, interval);
}

function stopPolling() {
    if (intervalId) {
        clearInterval(intervalId);
        intervalId = null;
    }
}

function trackProgress(interval = 1000) {
    isPollingActive = true;
    prevStatus = 0;
    const query = `sessionGuid:'${sessionGuid}'`;
    startPolling(() => {
        reqsvr2("service/CommonZK.asmx/GetOperationStatus", query, function (data) {
            const result = JSON.parse(data.d);
            if (result.success) {
                const details = result.message;
                if (details.length > prevStatus) {
                    tbl_set_result2('#div_person_data', details);
                    prevStatus = details.length;
                }
            } else {
                alert_error(result.message);
            }
        });
    }, interval);
}

function startStatusPolling(interval = 1000) {
    isPollingActive = true;
    const query = `sessionGuid:'${sessionGuid}'`;
    startPolling(() => {
        reqsvr2("service/CommonZK.asmx/GetOperationStatus", query, function (data) {
            const result = JSON.parse(data.d);
            if (result.success) {
                updateDeviceTable(result.message);
            } else {
                alert_error(result.message);
            }
        });
    }, interval);
}

function updateDeviceTable(details) {
    if (!details || !details.includes('☺')) return;
    const arr = details.split('☻');
    let td, pair;
    arr.forEach((row) => {
        if (row.includes('☺')) {
            pair = row.split('☺');
            td = document.querySelector(`#body_other_device tr[code='${pair[0]}'] td:last-child`);
            if (td) {
                td.innerHTML = pair[1];
            }
        }
    });
}

function manageOtherDeviceBtns(isBusy) {
    $('#cancel_other_device_modal_btn').toggleClass('hide', !isBusy);
    $('#remove_from_other_device_btn').toggleClass('hide', isBusy);
    $('#send_other_device_btn').toggleClass('hide', isBusy);
}

function executeMultiDeviceOperation(url, query) {
    document.querySelectorAll(`#body_other_device tr td:last-child`).forEach((td) => td.innerHTML = '');
    start_function(false);
    manageOtherDeviceBtns(true);

    reqsvr(url, query, function (data) {
        isPollingActive = false; // متوقف کردن polling
        end_function();
        manageOtherDeviceBtns(false);
        const result = JSON.parse(data.d);
        if (result.success) {
            updateDeviceTable(result.details);
            alert_success(result.message);
        } else {
            alert_error(result.message);
        }
    });
    startStatusPolling(2000); // شروع polling
}

function setupSearchableInputs() {
    const tableBody = document.getElementById('body_person_data');
    if (!tableBody) return;

    const table = $('#tbl_person_data').DataTable();

    tableBody.querySelectorAll('input[type="text"], input[type="tel"]').forEach(input => {
        input.addEventListener('input', function () {
            const td = this.parentNode;
            const hiddenSpan = td.querySelector('span.hidden');
            if (hiddenSpan) {
                hiddenSpan.textContent = this.value;
            }
            table.cell(td).invalidate();
        });
    });

    tableBody.querySelectorAll('input[name="admin"]').forEach(checkbox => {
        checkbox.addEventListener('change', function () {
            const td = this.parentNode;
            const hiddenSpan = td.querySelector('span.hidden');
            if (hiddenSpan) {
                hiddenSpan.textContent = this.checked ? "1" : "0";
            }
            table.cell(td).invalidate();
        });
    });
}
