﻿
let staticGuid = '';
const columnMap = {
    checkbox: 0,
    zone_name: 1,
    location: 2,
    ip_address: 3,
    port_address: 4,
    attendance: 5,
    connect_btn: 6,
    ping: 7,
    _time: 8,
    _user: 9,
    _face: 10,
    _finger: 11,
    _record: 12
};

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    loadDeviceStatus();
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function getSelectedTableItems(tblName, checkboxName) {
    let tr;
    let trCode;
    let items = [];
    const tableBody = document.getElementById(`body_${tblName}`);
    if (tableBody && (tableBody.innerHTML.length > 0)) {
        let flag = (checkboxName == undefined);
        tableBody.querySelectorAll('tr>td:first-child>input:checked').forEach(
            (item) => {
                tr = item.closest('tr');
                if (checkboxName) {
                    flag = (tr.querySelector(`td>input[name='${checkboxName}'].changed`) != undefined);
                }
                if (flag) {
                    trCode = tr.getAttribute('code');
                    items.push(trCode)
                }
            })
    }
    return items;
}

function loadDeviceStatus() {
    const query = `staticGuid:\"${staticGuid}\"`;
    reqsvr("service/CommonZK.asmx/LoadDeviceStatus", query, function (data) {
        if (!data.d) return;
        if (!staticGuid && data.d[3]) {
            staticGuid = data.d[3];
        }
        if (data.d[2].length) {
            load_cb_not_select("#zone_selector", data.d[2]);
        }
        if (data.d[0].length) {
            alert_error(data.d[0]);
        } else {
            document.querySelectorAll('#container > .btn-group > button').forEach((btn) => btn.classList.remove('hide'));
        }
        loadTable(data.d[1]);
    });
}

function getDevicePing() {
    const selectedDevices = getSelectedTableItems('devicepull');
    if (selectedDevices.length === 0) {
        alert_error("هیچ دستگاهی انتخاب نشده است");
        return;
    }
    selectedDevices.forEach(deviceCode => {
        const pingCell = document.querySelector(`#tbl_devicepull tr[code="${deviceCode}"] td:nth-child(${columnMap['ping'] + 1})`);
        if (pingCell) {
            pingCell.textContent = '';
            pingCell.title = '';
            const query = `id:${deviceCode}`;
            reqsvr("service/CommonZK.asmx/TestDevicePing", query, function (data) {
                const result = JSON.parse(data.d);
                if (result.success) {
                    pingCell.textContent = result.message;
                } else {
                    pingCell.textContent = '⚠';
                    pingCell.title = result.message;
                }
            });
        }
    })
}

function getDeviceInfo() {
    const selectedDevices = getSelectedTableItems('devicepull');
    if (selectedDevices.length === 0) {
        alert_error("هیچ دستگاهی انتخاب نشده است");
        return;
    }
    selectedDevices.forEach(deviceCode => {
        const row = document.querySelector(`#tbl_devicepull tr[code="${deviceCode}"]`);
        if (row) {
            const cells = row.querySelectorAll('td');
            const selected_td = cells[columnMap['checkbox']];
            selected_td.style.backgroundColor = 'yellow';
            selected_td.title = 'در انتظار پاسخ دستگاه...';
            const query = `id:${deviceCode},staticGuid:\"${staticGuid}\"`;
            reqsvr("service/CommonZK.asmx/GetDeviceReport", query, function (data) {
                const result = JSON.parse(data.d);
                if (result.success) {
                    if (result.message.includes('☻')) {
                        const arr = result.message.split('☻');
                        let pair;
                        arr.forEach((item) => {
                            if (item.includes('☺')) {
                                pair = item.split('☺');
                                cells[columnMap[pair[0]]].textContent = pair[1];
                            }
                        });
                        selected_td.style.backgroundColor = 'greenyellow';
                        selected_td.title = '';
                    }
                } else {
                    selected_td.style.backgroundColor = 'red';
                    selected_td.title = result.message;
                }
            });
        }
    });
}

function openDeviceList() {
    open_form_("../../page/DeviceConnection/ZK/DeviceListForm.aspx", 'فرم لیست دستگاه ها', '', '', 'loadDeviceStatus');
}

function openFilter() {
    const filterSection = document.getElementById('filter_section');
    if (filterSection.classList.contains('in')) {
        $(filterSection).collapse('hide');
    } else {
        $(filterSection).collapse('show');
    }
}

function applyFilter() {
    applyFilters();
    $('#filter_section').collapse('hide');
}

function closeFilter() {
    $('#filter_section').collapse('hide');
}

function openDeviceConnection(deviceCode) {
    open_form_("../../page/DeviceConnection/ZK/DeviceConnectionForm.aspx", 'فرم ارتباط با دستگاه', deviceCode, '');

}

function applyFilters() {
    const zoneSelector = document.getElementById('zone_selector');
    const attendanceSelector = document.getElementById('attendance_selector');
    const selectedZone = [...zoneSelector.options].filter(option => option.selected).map(option => option.value);
    const selectedAttendance = [...attendanceSelector.options].filter(option => option.selected).map(option => option.value);
    const query = `zone:\"${selectedZone.join()}\", attendance:\"${selectedAttendance.join()}\"`;
    reqsvr("service/CommonZK.asmx/ApplyFilters", query, function (data) {
        if (data.d) {
            const result = JSON.parse(data.d);
            loadTable(result.message);
            if (!result.success) {
                alert_error('هیچ دستگاهی یافت نشد');
            }
        }
    });
}

function loadTable(data) {
    load_tbl_chb(data, "devicepull");
    document.querySelectorAll('.btn-op').forEach(btn => {
        btn.addEventListener('click', () => {
            const deviceCode = btn.getAttribute('data-code');
            openDeviceConnection(deviceCode);
        });
    });
}
