﻿
let ipBox;
let inputs;
let deviceCode = -1

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    if (mode_form) {
        transferData = initial_page(500, 600);
        //parent.win.maximize();
    } else {
        transferData = initial_tab();
    }

    ipBox = document.getElementById('ip_box');

    deviceCode = transferData[0] * 1;
    let query = `deviceCode:${deviceCode}`;
    reqsvr("LoadData", query, function (data) {
        if (data.d) {
            load_cb("#dev_kind_selector", data.d[0]);
            load_cb("#cb_device_zone", data.d[2]);
            if (data.d[1]) {
                // داده‌های دستگاه را از JSON بخوان
                const deviceInfo = JSON.parse(data.d[1]);
                // مقداردهی فیلدها
                $('#dev_number').val(deviceInfo.number);
                $('#dev_location').val(deviceInfo.location);
                $('#port_box').val(deviceInfo.port_address);
                $('#dev_password').val(deviceInfo.password);
                $('#arrival_key').val(deviceInfo.arrival_key);
                $('#exit_key').val(deviceInfo.exit_key);
                $('#leave_key').val(deviceInfo.leave_key);
                $('#mission_key').val(deviceInfo.mission_key);
                $('#detail_box').val(deviceInfo.detail);

                $('#used_card_id').prop('checked', deviceInfo.card_id === 1);
                $('#skip_attendance').prop('checked', deviceInfo.skip_attendance === 1);
                $('#out_of_service').prop('checked', deviceInfo.out_of_service === 1);

                $('#dev_kind_selector').selectpicker('val', deviceInfo.device_kind_id);
                $('#cb_device_zone').selectpicker('val', deviceInfo.device_zone_id);

                // IP Address
                ipBox.value = deviceInfo.ip_address;
                const ipParts = deviceInfo.ip_address.split(".");
                document.querySelectorAll("#ipInputContainer>.ip-part").forEach((input, i) => {
                    input.value = ipParts[i] || "";
                });
            }
        }
    });

    inputs = document.querySelectorAll("#ipInputContainer>.ip-part");

    inputs.forEach((input, index) => {
        input.addEventListener("input", function () {
            // فقط عدد بگیر
            this.value = this.value.replace(/[^0-9]/g, '');

            // حرکت خودکار به فیلد بعدی
            if (this.value.length === this.maxLength && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }

            updateHiddenField();
        });

        input.addEventListener("keydown", function (e) {
            // حرکت به عقب با Backspace
            if (e.key === "Backspace" && this.value === "" && index > 0) {
                inputs[index - 1].focus();
            }
            // حرکت به جلو با نقطه (dot)
            if (e.key === "." && this.value.length > 0 && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }
        });
    });
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function updateHiddenField() {
    const values = Array.from(inputs).map(input => input.value.trim());
    const isValid = values.every(val => val === "" || (val.length <= 3 && parseInt(val) <= 255));
    if (isValid && (values.every(val => val !== ""))) {
        ipBox.value = values.join(".");
    } else {
        ipBox.value = "";
    }
}

function save() {
    const isError = check_force_error('#container');
    if (isError) return;

    // جمع‌آوری اطلاعات ورودی
    const deviceData = {
        deviceCode: deviceCode,
        number: $('#dev_number').val(),
        location: $('#dev_location').val().trim(),
        device_kind_id: $('#dev_kind_selector').val(),
        ip_address: ipBox.value,
        port_address: $('#port_box').val(),
        password: $('#dev_password').val(),
        arrival_key: $('#arrival_key').val().trim(),
        exit_key: $('#exit_key').val().trim(),
        leave_key: $('#leave_key').val().trim(),
        mission_key: $('#mission_key').val().trim(),
        detail: $('#detail_box').val().trim(),
        device_zone_id: $('#cb_device_zone').val(),
        card_id: $('#used_card_id').prop('checked') ? 1 : 0,
        skip_attendance: $('#skip_attendance').prop('checked') ? 1 : 0,
        out_of_service: $('#out_of_service').prop('checked') ? 1 : 0
    };

    // تبدیل به JSON
    const _json = JSON.stringify(deviceData);

    const query = `deviceInfo:\'${_json}\'`;

    reqsvr("DeviceDefinitionForm.aspx/SaveDeviceInfo", query, function (data) {
        if (data.d) {
            switch (data.d) {
                case "-1":
                    $('#dev_location').addClass('red_border');
                    alert_error('محل نصب نمی تواند تکراری باشد');
                    break;
                case "0":
                    alert_error('دستگاه ثبت نشد');
                    break;
                default:
                    call_fnc();
                    alert_success("ذخیره شد");
                    close();
                    break;
            }
        }
    });

}
