﻿
let startDate = '';
let endDate = '';
let currentDate = '';
let sessionGuid = null;
let isCanceled = false;
let isReadFile = false;
let fakeCode = 0;
let statusPollingInterval = null;
let selectedDeviceCode = '';
let xml = '';

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    if (mode_form) {
        transferData = initial_page(780, 500);
        //parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    selectedDeviceCode = transferData[0];
    const isMobile = ('ontouchstart' in document.body) && ((window.outerWidth <= 700) || (window.outerHeight <= 500));
    if (!isMobile) {
        $('#show_person_btn').removeClass('hide');
        $('#get_file_btn').removeClass('hide');
    }

    $('#device_selector').on('change', function () {
        $('#all_trafic').text(0);
        $('#read_trafic').text(0);
        $('#save_trafic').text(0);
        sessionGuid = null;
        deviceSelected();
    });

    load();
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function load() {
    reqsvr("service/CommonZK.asmx/GetDeviceList", "", function (data) {
        if (data.d) {
            xml = data.d[0];
            currentDate = data.d[1];
            load_cb("#device_selector", xml);
            if ((selectedDeviceCode) && (getXmlPart('name', selectedDeviceCode))) {
                $('#device_selector').selectpicker('val', selectedDeviceCode);
            }
            deviceSelected();
        }
    });
}

function showDeviceList() {
    open_form_("../../page/DeviceConnection/ZK/DeviceListForm.aspx", 'فرم لیست دستگاه ها', '', 'load');
}

function checkDeviceConnect() {
    if (sessionGuid && (fakeCode == 0)) {
        sendDeviceCommand("checkcoonnect", () => refreshButtons(false));
    } else {
        fakeCode = 0;
        const query = `deviceCode:${selectedDeviceCode},fakeCode:0`;
        reqsvr("service/CommonZK.asmx/InitDeviceSession", query, function (data) {
            const result = JSON.parse(data.d);
            if (result.success) {
                sessionGuid = result.message;
                sendDeviceCommand("checkcoonnect", () => refreshButtons(false));
            } else {
                alert_error(result.message);
            }
        });
    }
}

function restartDevice() {
    sendDeviceCommand("restartdevice", (response) => {
        refreshButtons(true);
        alert_success(response);
    });
}

function getDeviceInfo() {
    sendDeviceCommand("getdeviceinfo", (response) => {
        if (response) {
            const pre = `<pre style="text-align: right;">${response.replaceAll('☺', ': ').replaceAll('☻', '\n')}</pre>`;
            const title = `مشخصات دستگاه ${getXmlPart('name', selectedDeviceCode)}`;
            alert_message(pre, title);
        }
    });
}

function removeDeviceLog() {
    sendDeviceCommand("clearglog", (response) => alert_success(response));
}

function removeDeviceAdmin() {
    sendDeviceCommand("clearadmin", (response) => alert_success(response));
}

function setDeviceTime() {
    sendDeviceCommand("getdevicetime", (deviceTime) => {
        const msg = `<p>ساعت فعلی دستگاه: ${deviceTime}<br/>آیا مایلید ساعت دستگاه با سیستم تنظیم شود؟</p>`;
        confirm_alert_msg(msg, () => sendDeviceCommand("setdevicetime", (response) => alert_success(response)), () => { });
    })
}

function showManagePerson() {
    if (!sessionGuid) return;
    const _url = "../../page/DeviceConnection/ZK/ManagePerson.aspx";
    const _title = `مدیریت پرسنل دستگاه ${getXmlPart('name', selectedDeviceCode)}`;
    open_form_(_url, _title, sessionGuid, '');
}

function getAllLog() {
    const startDate = document.getElementById('start-date').value;
    const endDate = document.getElementById('end-date').value;
    let isCorrect = CMPDay(startDate, endDate, startDate);
    if (isCorrect == false) {
        alert_error("ترتیب تاریخ ها رعایت نشده است ");
        return;
    }
    $('#get_dates_modal').modal('hide');
    if (isReadFile) {
        $('#file_input').val('').click();
        return;
    } else {
        const query = `sessionGuid:'${sessionGuid}', startDate:'${startDate}', endDate:'${endDate}'`;
        callService('service/CommonZK.asmx/StartGetLog', query);
    }
}

function cancelCommand() {
    const query = `sessionGuid:'${sessionGuid}'`;
    reqsvr("service/CommonZK.asmx/CancelCommand", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            alert_message(result.message);
            isCanceled = true;
        }
    });
}

function showAddPerson() {
    if (!sessionGuid) return;
    const _url = "../../page/DeviceConnection/ZK/AddPersonToDevice.aspx";
    const _title = `افزودن پرسنل به دستگاه ${getXmlPart('name', selectedDeviceCode)}`;
    open_form_(_url, _title, sessionGuid, '');
}

function getFile() {
    if (sessionGuid) {
        showDateModal(true);
    } else {
        fakeCode = -255;
        const query = `deviceCode:${selectedDeviceCode},fakeCode:-255`;
        reqsvr("service/CommonZK.asmx/InitDeviceSession", query, function (data) {
            const result = JSON.parse(data.d);
            if (result.success) {
                sessionGuid = result.message;
                showDateModal(true);
            } else {
                alert_error('خطا رخ داده است');
            }
        });
    }
}

function getXmlPart(name, code) {
    var selectedRow = search_xml(xml, code);
    let result = '';
    try {
        result = $(selectedRow).find(name).text();
    } catch { }
    return result
}

function deviceSelected() {
    selectedDeviceCode = $('#device_selector').val();
    let data = getXmlPart('detail', selectedDeviceCode);
    $('#device_detail').text(data);
    data = getXmlPart('ip_address', selectedDeviceCode);
    $('#device_ip').text(data);
    data = getXmlPart('port_address', selectedDeviceCode);
    $('#device_port').text(data);
    let isHide = (getXmlPart('skip_attendance', selectedDeviceCode) > 0);
    $('#get_dates_btn').toggleClass('hidden', isHide);
    $('#get_file_btn').toggleClass('hidden', isHide);
    isHide = (getXmlPart('used_card_id', selectedDeviceCode) == 0);
    $('#get_dates_btn span').toggleClass('hidden', isHide);
    refreshButtons(true);
}

function refreshButtons(isDisabled) {
    $('.op').prop('disabled', isDisabled);
    $('#check_connect_btn').prop('disabled', !isDisabled).html(isDisabled ? '<i class="fa fa-plug"></i> بررسی ارتباط' : 'متصل به دستگاه');
}

function sendDeviceCommand(cmd, onSuccess) {
    let pwd = '';
    const payload = {
        sessionGuid: sessionGuid,
        command: cmd
    };

    const executeCommand = () => {
        const query = `data:'${JSON.stringify(payload)}'`;
        startLoading();
        reqsvr("service/CommonZK.asmx/ExecuteCommand", query, function (data) {
            stopLoading();
            const result = JSON.parse(data.d);
            if (result.success) {
                onSuccess(result.message);
            } else {
                alert_error(result.message);
                if ((result.message == 'خطا در اتصال به دستگاه') || (result.message == 'خطا در راه اندازی مجدد دستگاه')) {
                    refreshButtons(true);
                }
            }
        });
    }

    if ((cmd == 'clearglog') || (cmd == 'clearadmin')) {
        const title = (cmd == 'clearglog') ? 'آیا مایلید اطلاعات حافظه دستگاه حذف گردد؟' : 'آیا مایلید مدیر روی دستگاه حذف گردد؟';
        const my_html = `<div style="text-align: center; margin-top: 15px;">
        <label for="pwd" style="margin-bottom: 5px;">رمز :</label>
        <input id="pwd" type="password" maxlength="8" autocomplete="off" placeholder="رمز را وارد کنید"
        style="width: 50%; text-align: center; border-radius: 4px; padding: 3px;"/></div>`;
        show_html_alert(title, my_html, () => { },
            () => {
                pwd = document.getElementById('pwd').value;
                if (!pwd) {
                    Swal.showValidationMessage('فیلد خالی است');
                    return false;
                }
                if (pwd.length != 7) {
                    Swal.showValidationMessage('رمز معتبر نمی باشد');
                    return false;
                }
            }, () => {
                payload.password = pwd;
                executeCommand();
            })
    }
    else {
        executeCommand();
    }
}

function startLoading(isHide_cancelBtn = true) {
    document.getElementById('container').classList.add('loading');
    $('#cancel_btn').toggleClass('invisible', isHide_cancelBtn);
}

function stopLoading() {
    document.getElementById('container').classList.remove('loading');
    $('#cancel_btn').addClass('invisible');
}

function startPollingStatus() {
    stopPollingStatus();
    statusPollingInterval = setInterval(() => {
        const query = `sessionGuid:'${sessionGuid}'`;
        reqsvr("service/CommonZK.asmx/GetLogStatus", query, function (data) {
            const status = data.d;
            if (!status) return;
            $('#all_trafic').text(status.All);
            $('#read_trafic').text(status.Read);
            $('#save_trafic').text(status.Saved);

            if (!status.IsRunning) {
                stopPollingStatus();
                stopLoading();
                if (!isCanceled) {
                    alert_success(status.Message);
                }
                isCanceled = false;
            }
        });
    }, 1000);
}

function stopPollingStatus() {
    if (statusPollingInterval) {
        clearInterval(statusPollingInterval);
        statusPollingInterval = null;
    }
}

function show_html_alert(title_, html_, fnc_open, fnc_pre, fnc) {
    (async () => {
        const { value: formValues } = await Swal.fire({
            title: title_,
            html: html_,
            allowEscapeKey: false,
            allowOutsideClick: false,
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'تائید',
            cancelButtonText: 'انصراف',
            position: "top",
            focusConfirm: false,
            didOpen: () => {
                fnc_open();
            },
            preConfirm: fnc_pre
        });
        if (formValues)
            fnc(formValues);
    })()
}

function showDateModal(readFile = false) {
    isReadFile = readFile;
    const query = `sessionGuid:'${sessionGuid}'`;
    reqsvr("service/CommonZK.asmx/GetUpdateDate", query, function (data) {
        if (data.d) {
            const isCorrect = CMPDay(data.d, currentDate, data.d);
            document.getElementById('start-date').value = isCorrect ? data.d : currentDate;
            document.getElementById('end-date').value = currentDate;
            $('#get_dates_modal').modal('show');
        }
    });
}

function callService(url, query) {
    startLoading(false);
    reqsvr(url, query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            startPollingStatus();
        } else {
            alert_error(result.message);
        }
    });
}

///////////////////////////////////////////////////////
// upload file functions
///////////////////////////////////////////////////////

function showSelectedFileError(selectedFile) {
    let errorMessage = '';
    if ((selectedFile.size > 0) && (selectedFile.size < 10 * Math.pow(2, 20))) {
        const allowedExtensions = ['txt', 'dat'];
        const fileExt = selectedFile.name.split('.').pop().toLowerCase();
        if (!allowedExtensions.includes(fileExt)) {
            errorMessage = 'فایل انتخاب شده پشتیبانی نمی شود';
        }
    } else {
        if (selectedFile.size == 0) {
            errorMessage = 'فایل خالی است';
        } else {
            errorMessage = 'اندازه فایل باید کمتر از ۱۰ مگابایت باشد';
        }
    }
    return errorMessage;
}

function uploadFile(obj) {
    if (!obj.files[0]) return;
    const selectedFile = obj.files[0];
    const errorMessage = showSelectedFileError(selectedFile);
    if (errorMessage) {
        alert_error(errorMessage);
        return;
    }
    wait_();
    const formData = new FormData();
    formData.append('file', selectedFile);
    $.ajax({
        type: 'post',
        url: 'service/docUploader.ashx',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            if (response.trim() === 'ok') {
                const startDate = document.getElementById('start-date').value;
                const endDate = document.getElementById('end-date').value;
                const query = `sessionGuid:'${sessionGuid}', startDate:'${startDate}', endDate:'${endDate}', fileName:'${selectedFile.name}'`;
                callService('service/CommonZK.asmx/ProcessUploadedLog', query);
            } else {
                alert_error("خطا در آپلود فایل.");
            }
        },
        error: function () {
            alert_error("ارتباط با سرور برقرار نشد یا خطایی رخ داد.");
        },
        complete: function () {
            unwait_();
        }
    });
}
