﻿
const noName = '...';
const person = {};
let target = {};
let xmlPerson = '';
let imageName = '';

let sessionGuid = null;
let hasFinger = null;
let hasTemplateFace = null;
let hasVisibleLight = null;
let intervalId = null;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

$(document).ready(function () {
    let transferData;
    if (mode_form) {
        transferData = initial_page(780, 500);
    } else {
        transferData = initial_tab();
    }
    sessionGuid = transferData[0];

    const query = `sessionGuid:'${sessionGuid}'`;
    reqsvr("service/CommonZK.asmx/GetAddPersonFormConfig", query, function (data) {
        const status = data.d;
        unwait_();
        if (!status) {
            alert_error('عدم شناسایی دستگاه با چهره یا انگشت');
            close();
            return;
        }
        hasFinger = status.hasFinger;
        hasTemplateFace = status.hasTemplateFace;
        hasVisibleLight = status.hasVisibleLight;
        xmlPerson = status.xmlPerson;
    });

    $('#container').on('click', function (e) {
        if (e.target.closest('button')) {
            check_force_error('#container');
        }
    });

    $('#pid_box').on('input', function () {
        let pid = $('#pid_box').val();
        if (pid == 0) pid = '';
        resetParams(pid);
    });
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function receive_output(imagePath, id) {    //  data: image path or data    id: The id of the clicked item
    if ((id !== 'camera_btn') || (!imagePath.startsWith('files/temp/')) || (!imagePath.endsWith('.jpg'))) return;
    const fileName = imagePath.split('.')[0].split('/').pop();
    const query = `sessionGuid:'${sessionGuid}',fileName:'${fileName}.jpg',pid:${person.id}`;
    reqsvr("service/CommonZK.asmx/MoveCroppedImageToSession", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            const fullPath = result.details;
            $('#photo').attr('src', fullPath).removeClass('invisible');
            imageName = fullPath.split('.jpg')[0].split('/').pop();
            buttonState('#send_btn', false);
            buttonState('#profile_saving_btn', false);
            if ((imageName.length == 0) || (person.id.length == 0)) {
                $('#send_btn').prop('disabled', true);
                $('#profile_saving_btn').prop('disabled', true);
            }
        } else {
            alert_error(result.message);
        }
    });
}

function reloadView() {
    if (!person.id) return;
    resetParams(person.id);
}

function sendPhotoToDevice() {
    buttonState('#send_btn', true);
    if (!person.id) return;
    if (!imageName) {
        alert_error('اطلاعات مورد نظر یافت نشد');
        return;
    }
    const name = (person.name === noName) ? '' : person.name;
    const query = `sessionGuid:'${sessionGuid}',fileName:'${imageName}.jpg',pid:${person.id},personName:'${name}'`;
    reqsvr("service/CommonZK.asmx/SendPhotoToVisibleLightDevice", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            alert_success(result.message);
        } else {
            alert_error(result.message);
        }
    });
}

function checkData() {
    if (!person.id) return;
    if (Object.keys(target).length === 0) return;
    const isFaceMode = (target.index == 111);
    const kind = (isFaceMode) ? 'چهره' : 'انگشت';
    const query = `sessionGuid:'${sessionGuid}',pid:${target.pid},index:${target.index}`;
    const url = `service/CommonZK.asmx/${(isFaceMode) ? 'CheckFaceStatus' : 'CheckFingerStatus'}`;
    reqsvr(url, query, function (data) {
        try {
            const result = JSON.parse(data.d);
            if (result.success) {
                if (isFaceMode) {
                    $('#photo').attr('src', result.details).removeClass('invisible');
                    buttonState('#profile_saving_btn', false);
                }
                buttonState('#store_btn', false);
                $('#check-btn').addClass('hide');
                alert_success(`${kind} با موفقیت ثبت شد`);
            } else {
                alert_error(result.message);
                startCountdown();
            }
        } catch (err) {
            alert_error(`خطای سیستمی : ${err.message}`);
        }
    });
}

function storeBiometricTemplate() {
    buttonState('#store_btn', true);
    if ((!target.pid) || (!target.index)) {
        alert_error('اطلاعات مورد نظر یافت نشد');
        return;
    }
    const query = `sessionGuid:'${sessionGuid}',pid:${target.pid},index:${target.index}`;
    reqsvr("service/CommonZK.asmx/SaveBiometricTemplate", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            alert_success(result.message);
        } else {
            alert_error(result.message);
        }
    });
}

function profileSaving() {
    buttonState('#profile_saving_btn', true);
    if (!person.id) return;
    const query = `sessionGuid: '${sessionGuid}',pid:${person.id}`;
    reqsvr("service/CommonZK.asmx/SaveProfileImage", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            alert_success(result.message);
        } else {
            alert_error(result.message);
        }
    });
}

function getName(pid) {
    let name = '';
    const hasPid = pid.length > 0;
    if (hasPid) {
        var selectedRow = search_xml(xmlPerson, pid);
        name = $(selectedRow).find("name").text();
        $('#camera_btn').toggleClass('hide', !hasVisibleLight);
        if (!hasVisibleLight && hasFinger) {
            $('#add_finger_btn').removeClass('hide');
        }
        if (hasTemplateFace || hasVisibleLight) {
            $('#add_face_btn').removeClass('hide');
        }
    } else {
        $('#pid_box').val(pid);
    }
    $('#pid_box').toggleClass('red_border', !hasPid);
    $('#camera_btn').prop('disabled', !hasPid);
    if (!hasVisibleLight && hasFinger) {
        $('#add_finger_btn').prop('disabled', !hasPid);
    }
    if (hasTemplateFace || hasVisibleLight) {
        $('#add_face_btn').prop('disabled', !hasPid);
    }
    $('#name_box').text(name.length > 0 ? name : noName);
    person.id = pid;
    person.name = name;
}

function resetParams(pid) {
    imageName = '';
    $('#photo').attr('src', '#').addClass('invisible');
    buttonState('#check-btn', true);
    buttonState('#send_btn', true);
    buttonState('#store_btn', true);
    buttonState('#profile_saving_btn', true);
    target = {};
    getName(pid);
}

function buttonState(btnSelector, hideAndDisable) {
    const $btn = $(btnSelector);
    $btn.toggleClass('hide', hideAndDisable);
    $btn.prop('disabled', hideAndDisable);
}

function startCountdown(seconds = 30) {     //  شمارش معکوس 30 ثانیه
    if (intervalId) {
        clearInterval(intervalId);
    }
    intervalId = setInterval(() => {
        seconds--;
        if (seconds <= 0) {
            $('#container').removeClass('loading');
            $('#check-btn i').text('');
            $('#check-btn').prop('disabled', false);
            clearInterval(intervalId);
        } else {
            $('#check-btn i').text(seconds);
            $('#check-btn').removeClass('hide').prop('disabled', true);
        }
    }, 1000);
}

function enrollBiometric(isfaceMode) {
    if (!person.id) return;
    resetParams(person.id);
    const name = (person.name === noName) ? '' : person.name;
    const query = `sessionGuid:'${sessionGuid}',pid:${person.id},personName:'${name}',isfaceMode:${isfaceMode}`;
    reqsvr("service/CommonZK.asmx/EnrollUserBiometric", query, function (data) {
        const result = JSON.parse(data.d);
        if (result.success) {
            alert_message(result.message);
            target.pid = person.id;
            target.index = result.details;

            $('#container').addClass('loading');
            const caption = `بررسی ثبت ${(isfaceMode) ? 'چهره' : 'انگشت'}`;
            $('#check-btn span').text(caption);
            startCountdown();
        } else {
            alert_error(result.message);
        }
    });
}


