﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ManagePerson.aspx.cs" Inherits="TimeWork.ManagePerson" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../../style/Treeview/Treeview.css" rel="stylesheet" />
    <link href="../../../style/datatable/jquery.dataTables.min.css" rel="stylesheet" />
    <link href="../../../style/timepicker/bootstrap-clockpicker.css" rel="stylesheet" />
    <link href="../../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../../style/sanaco.css" rel="stylesheet" />

    <script src="../../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../../style/Bootstrap/bootstrap.min.js"></script>
    <script src="../../../style/alert/sweetalert.js"></script>
    <script src="../../../style/Treeview/Treeview.js"></script>
    <script src="../../../style/select/bootstrap-select.js"></script>
    <script src="../../../style/mask/jquery.mask.min.js"></script>
    <script src="../../../style/timepicker/bootstrap-clockpicker.min.js"></script>
    <script src="../../../style/calendar/js-persian-cal.min.js"></script>
    <script src="../../../style/datatable/dataTables.min.js"></script>
    <script src="../../../style/datatable/dataTables.bootstrap.min.js"></script>
    <script src="../../../script/fnc.js"></script>

    <%--Attachment css--%>
    <link href="css/managePerson.css" rel="stylesheet" />
</head>
<body>
    <div id="container">
        <header>
            <div class="btn-group">
                <button type="button" id="get_device_prson_btn" class="op btn btn-default" onclick="getDevicePrson()">فراخوانی از دستگاه</button>
                <button type="button" id="select_person_btn" class="op btn btn-default" onclick="selectPerson()">فراخوانی از بانک اطلاعاتی</button>
            </div>
        </header>

        <main>
            <article>
                <div class="btn-group-vertical">
                    <button type="button" disabled="disabled" id="save_db_btn" class="op btn btn-default" onclick="saveDB()">ذخیره در بانک اطلاعاتی</button>
                    <button type="button" disabled="disabled" id="remove_from_device_btn" class="op btn btn-default" onclick="removeFromDevice()">حذف از دستگاه</button>
                    <button type="button" disabled="disabled" id="send_device_btn" class="op btn btn-default" onclick="sendDevice()">ارسال روی دستگاه</button>
                    <button type="button" disabled="disabled" id="open_other_devices_modal_btn" class="op btn btn-default" onclick="openOtherDevicesModal()">ارسال روی سایر دستگاه ها</button>
                </div>
                <button type="button" id="cancel_btn" class="btn btn-info btn-block hide" onclick="cancelCommand()">توقف</button>
                <footer id="bottom_buttons">
                    <div class="image-background">
                        <img id="selected_person_photo" src="#" />
                    </div>
                </footer>
            </article>

            <div>
                <div id="div_person_data"></div>
                <footer id="bottom_person_data">
                </footer>
            </div>
        </main>
    </div>

    <section>
        <div id="device_user_modal" class="modal fade unselectable" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" onclick="cancelCommand()" aria-hidden="true"><span class="fa fa-close"></span></button>
                    <h5 class="modal-title">لیست پرسنل روی دستگاه</h5>
                </div>
                <div class="modal-body">
                    <aside>
                        <div id="div_device_person"></div>
                        <button type="button" id="prson_selected_btn" class="btn btn-success" onclick="getPrsonSelected()">تایید</button>
                        <button type="button" id="cancel_modal_btn" class="btn btn-info hide" onclick="cancelModal()"></button>
                    </aside>
                </div>
            </div>
        </div>
    </div>

    <div id="other_device_modal" class="modal fade unselectable" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" onclick="cancelCommand()" aria-hidden="true"><span class="fa fa-close"></span></button>
                    <h5 class="modal-title">دستگاه های مرتبط</h5>
                </div>
                <div class="modal-body">
                    <aside>
                        <div id="div_other_device"></div>
                        <div class="modal-bottom btn-group">
                            <button type="button" id="send_other_device_btn" class="op btn btn-success" onclick="sendOtherDevice()">ارسال</button>
                            <button type="button" id="remove_from_other_device_btn" class="op btn btn-danger" onclick="removeFromOtherDevice()">حذف</button>
                            <button type="button" id="cancel_other_device_modal_btn" class="btn btn-info hide" onclick="cancelCommand()">انصراف</button>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>
    </section>

    <%--Attachments js--%>
    <script src="js/managePerson.js"></script>
</body>
</html>
