﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DeviceDefinitionForm.aspx.cs" Inherits="TimeWork.DeviceDefinitionForm" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../../style/Treeview/Treeview.css" rel="stylesheet" />
    <link href="../../../style/sanaco.css" rel="stylesheet" />

    <%--Begin link--%>
    <link href="css/deviceDefinition.css" rel="stylesheet" />
    <%--End link--%>

    <script src="../../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../../style/Bootstrap/bootstrap.min.js"></script>
    <script src="../../../style/alert/sweetalert.js"></script>
    <script src="../../../style/Treeview/Treeview.js"></script>
    <script src="../../../style/select/bootstrap-select.js"></script>
    <script src="../../../script/fnc.js"></script>
    <%--Begin script--%>
    <script src="js/deviceDefinition.js"></script>
    <%--End script--%>
</head>
<body>

    <div id="container" class="label-above">
        <div class="row">
            <!-- شماره دستگاه -->
            <div class="col-xs-6">
                <label for="dev_number" class="control-label">
                    شماره دستگاه :
                <span class="red_">*</span>
                </label>
                <input type="number" id="dev_number" class="form-control" min="1" max="9999" force="1" />
            </div>

            <!-- نوع دستگاه -->
            <div class="col-xs-6">
                <label for="dev_kind_selector" class="control-label">
                    نوع دستگاه :
                <span class="red_">*</span>
                </label>
                <select id="dev_kind_selector" class="selectpicker" data-width="100%" data-size="7" force="1"></select>
            </div>
        </div>

        <div class="row">
            <!-- محل نصب دستگاه -->
            <div class="col-xs-6">
                <label for="dev_location" class="control-label">
                    محل نصب :
                <span class="red_">*</span>
                </label>
                <input type="text" id="dev_location" class="form-control" autocomplete="off" force="1" />
            </div>

            <!-- ناحیه نصب دستگاه -->
            <div class="col-xs-6">
                <label for="cb_device_zone" class="control-label">
                    ناحیه نصب :
                <span class="red_">*</span>
                </label>
                <div class="input-group">
                    <select id="cb_device_zone" name="device_zone_id" class="selectpicker" data-width="100%" data-size="7" force="1"></select>
                    <button id="show_device_zone_btn" class="btn btn-primary" onclick="show_table('device_zone','ناحیه نصب')" title="لیست نواحی">...</button>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- آدرس IP -->
            <div class="col-xs-12">
                <label class="control-label">
                    آدرس IP :
                <span class="red_">*</span>
                </label>
                <div id="ipInputContainer" class="form-inline">
                    <input type="text" maxlength="3" class="form-control ip-part align-center" force="1" />
                    <span>.</span>
                    <input type="text" maxlength="3" class="form-control ip-part align-center" force="1" />
                    <span>.</span>
                    <input type="text" maxlength="3" class="form-control ip-part align-center" force="1" />
                    <span>.</span>
                    <input type="text" maxlength="3" class="form-control ip-part align-center" force="1" />
                </div>
                <!-- Input پنهان برای ارسال به سرور -->
                <input type="hidden" id="ip_box" />
            </div>
        </div>

        <div class="row">
            <!-- شماره پورت -->
            <div class="col-xs-6">
                <label for="port_box" class="control-label">
                    شماره پورت :
                <span class="red_">*</span>
                </label>
                <input type="number" id="port_box" class="form-control" value="4370" min="1" max="65535" force="1" />
            </div>

            <!-- رمز دستگاه -->
            <div class="col-xs-6">
                <label for="dev_password" class="control-label">رمز دستگاه :</label>
                <input type="number" id="dev_password" class="form-control" value="0" min="0" max="999999999" />
            </div>
        </div>

        <div class="row">
            <!-- کلید ورود -->
            <div class="col-xs-6">
                <label for="arrival_key" class="control-label">کلید ورود :</label>
                <input type="text" id="arrival_key" class="form-control align-center" autocomplete="off" />
            </div>

            <!-- کلید خروج -->
            <div class="col-xs-6">
                <label for="exit_key" class="control-label">کلید خروج :</label>
                <input type="text" id="exit_key" class="form-control align-center" autocomplete="off" />
            </div>
        </div>

        <div class="row">
            <!-- کلید مرخصی -->
            <div class="col-xs-6">
                <label for="leave_key" class="control-label">کلید مرخصی :</label>
                <input type="text" id="leave_key" class="form-control align-center" autocomplete="off" />
            </div>

            <!-- کلید ماموریت -->
            <div class="col-xs-6">
                <label for="mission_key" class="control-label">کلید ماموریت :</label>
                <input type="text" id="mission_key" class="form-control align-center" autocomplete="off" />
            </div>
        </div>

        <div class="row">
            <!-- توضیحات -->
            <div class="col-xs-12">
                <label for="detail_box" class="control-label">توضیحات :</label>
                <input type="text" id="detail_box" class="form-control" autocomplete="off" />
            </div>
        </div>

        <div class="row">
            <!-- فرخوانی با شماره کارمندی -->
            <label for="used_card_id" class="flx col-xs-12">
                <input type="checkbox" id="used_card_id" class="" />
                <span>فرخوانی با شماره کارمندی</span>
            </label>
        </div>

        <div class="row">
            <!-- دستگاه تخلیه نشود -->
            <label for="skip_attendance" class="flx col-xs-12">
                <input type="checkbox" id="skip_attendance" class="" />
                <span>عدم تخلیه در سامانه حضور غیاب</span>
            </label>
        </div>

        <div class="row">
            <!-- دستگاه خارج از سرویس -->
            <label for="out_of_service" class="flx col-xs-12">
                <input type="checkbox" id="out_of_service" class="" />
                <span>غیرفعال</span>
            </label>
        </div>

    </div>

    <div class="toolbar-footer">
        <button id="save-btn" type="button" class="btn btn-success" onclick="save()">ذخیره <span class="fa fa-save"></span></button>
    </div>

</body>
</html>
