﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DeviceConnectionForm.aspx.cs" Inherits="TimeWork.DeviceConnectionForm" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="../../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../../style/sanaco.css" rel="stylesheet" />
    <%--Begin link--%>
    <link href="css/deviceConnection.css" rel="stylesheet" />
    <%--End link--%>

    <script src="../../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../../style/Bootstrap/bootstrap.min.js"></script>
    <script src="../../../style/alert/sweetalert.js"></script>
    <script src="../../../style/select/bootstrap-select.js"></script>
    <script src="../../../style/mask/jquery.mask.min.js"></script>
    <script src="../../../style/calendar/js-persian-cal.min.js"></script>
    <script src="../../../script/fnc.js"></script>
    <script src="../../../script/FncDate.js"></script>

    <%--Begin script--%>
    <script src="js/deviceConnection.js"></script>
    <%--End script--%>
</head>
<body>

    <div id="container" class="panel">
        <header>
            <div>
                <span>انتخاب دستگاه :</span>
                <div class="input-group">
                    <select id="device_selector" data-live-search="true" class="selectpicker" data-width="100%" data-size="7"></select>
                    <button  type="button" id="show_device_list_btn" class="btn btn-primary" onclick="showDeviceList()" title="لیست دستگاه">...</button>
                </div>
            </div>
            <div>
                <span>توضیحات :</span>
                <span id="device_detail"></span>
            </div>
            <div class="row">
                <span class="col-xs-4 align-right">آدرس شبکه :</span>
                <span id="device_port" class="col-xs-4 align-center"></span>
                <span id="device_ip" class="col-xs-4 align-left"></span>
            </div>
        </header>

        <main>
            <section>
                <div class="row">
                    <button type="button" id="check_connect_btn" class="btn btn-primary col-xs-12 col-sm-6 col-xs-12 col-sm-6" onclick="checkDeviceConnect()"><i class="fa fa-plug"></i> بررسی ارتباط</button>
                    <button type="button" id="set_time_btn" class="op btn btn-primary col-xs-12 col-sm-6" disabled="disabled" onclick="setDeviceTime()"><i class="fa fa-clock-o"></i> تنظیم ساعت دستگاه</button>
                </div>
                <div class="row">
                    <button type="button" id="remove_data_btn" class="op btn btn-primary col-xs-12 col-sm-6" disabled="disabled" onclick="removeDeviceLog()"><i class="fa fa-trash"></i> حذف ترددها</button>
                    <button type="button" id="clean_admin_btn" class="op btn btn-primary col-xs-12 col-sm-6" disabled="disabled" onclick="removeDeviceAdmin()"><i class="fa fa-user-times"></i> حذف مدیران</button>
                </div>
                <div class="row">
                    <button type="button" id="show_person_btn" class="op btn btn-primary col-xs-12 col-sm-6 hide" disabled="disabled" onclick="showManagePerson()"><i class="fa fa-users"></i> مدیریت پرسنل</button>
                    <button type="button" id="add_person_btn" class="op btn btn-primary col-xs-12 col-sm-6" disabled="disabled" onclick="showAddPerson()"><i class="fa fa-user-plus"></i> افزودن پرسنل</button>
                </div>
                <div class="row">
                    <button type="button" id="reset_btn" class="op btn btn-primary col-xs-12 col-sm-6" disabled="disabled" onclick="restartDevice()"><i class="fa fa-refresh"></i> راه‌اندازی مجدد</button>
                    <button type="button" id="info_btn" class="op btn btn-primary col-xs-12 col-sm-6" disabled="disabled" onclick="getDeviceInfo()"><i class="fa fa-info-circle"></i> اطلاعات دستگاه</button>
                </div>
                <div class="row">
                    <button type="button" id="get_dates_btn" class="op btn btn-primary col-xs-12 col-sm-6 hidden" disabled="disabled" onclick="showDateModal()"><i class="fa fa-arrow-circle-down"></i> تخلیه اطلاعات<span class="hidden">(شماره کارمندی)</span></button>
                    <button type="button" id="get_file_btn" class="btn btn-primary col-xs-12 col-sm-6 hide hidden" onclick="getFile()"><i class="fa fa-folder-open"></i> دریافت تردد از فایل</button>
                    <input id="file_input" type="file" accept=".txt,.dat" class="hide" onchange="uploadFile(this)" />
                </div>
            </section>
            <section>
                <div class="row">
                    <button id="cancel_btn" class="btn btn-info col-xs-12 invisible" onclick="cancelCommand()">انصراف</button>
                </div>
                <label>تعداد كل ركوردها :<span id="all_trafic">0</span></label>
                <label>تعداد خوانده شده :<span id="read_trafic">0</span></label>
                <label>تعداد ثبت شده :<span id="save_trafic">0</span></label>
            </section>
        </main>

        <div id="get_dates_modal" class="modal fade unselectable" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button class="close" data-dismiss="modal" aria-hidden="true"><span class="fa fa-close"></span></button>
                        <h5 class="modal-title">تعیین محدوده زمانی</h5>
                    </div>
                    <div class="modal-body">
                        <aside>
                            <label>
                                <span>از تاریخ : </span>
                                <input type="text" id="start-date" class="date form-control" />
                            </label>
                            <label>
                                <span>تا تاریخ : </span>
                                <input type="text" id="end-date" class="date form-control" />
                            </label>
                            <button id="get_all_log_btn" class="btn btn-success" onclick="getAllLog()">تایید</button>
                        </aside>
                    </div>
                </div>
            </div>
        </div>

    </div>

</body>
</html>
