﻿
const cmdArray = [];
let isRunning = false;
let isCanseled = false;

let cmdNum = 0;
let deviceID = -1;
let deviceSN = '';
let pageID = 0;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////



///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function canselCommand() {
    isCanseled = isRunning;
    cmdArray.length = 0;
}

function runCommand(codes, showResult_function, end_function) {
    if ((deviceID >= 0) && (cmdNum > 0)) {
        const _codes = (cmdNum > 11) ? codes : '';
        let userCmd = getUserCmd(deviceSN, _codes, cmdNum);
        cmdArray.push(userCmd);
        if (!isRunning) {
            sendCmd(showResult_function, end_function);
        }
    }
}

function runCommandWithSN(otherSN, codes, showResult_function, end_function) {
    if ((deviceID >= 0) && (cmdNum > 0)) {
        const _codes = (cmdNum > 11) ? codes : '';
        let userCmd = getUserCmd(otherSN, _codes, cmdNum);
        cmdArray.push(userCmd);
        if (!isRunning) {
            sendCmd(showResult_function, end_function);
        }
    }
}

function getUserCmd(sn, codes, cmdNum) {
    return { sn, codes, cmdNum };
}

async function sendCmd(showResult_function, end_function) {
    isRunning = true;
    let userCmd;
    let listCode;
    let query;
    let msg;
    while (cmdArray.length > 0) {
        userCmd = cmdArray.shift();
        listCode = userCmd.codes.split(',');
        for (let i = 0; i < listCode.length; i++) {
            query = `sn:'${userCmd.sn}',`;
            query += `codes:'${listCode[i]}',`;
            query += `cmdNum:${userCmd.cmdNum},`;
            query += `pageID:${pageID}`;
            msg = await cmdRun(query);
            showResult_function(msg, listCode[i], userCmd.sn);
            if (isCanseled) {
                break;
            }
        }
    }
    isRunning = false;
    isCanseled = false;
    end_function();
}

async function cmdRun(query) {
    let result = 253;
    const delay = (ms) => new Promise((resolve) => setTimeout(() => resolve(), ms));
    reqsvr("service/CommonTimmy.asmx/CmdRun", query, function (data) {
        if (data.d) {
            result = data.d;
        }
    });
    wait_();
    for (let j = 0; j < 30; j++) {
        await delay(100);
        if (result != 253) {
            break;
        }
    }
    unwait_();
    return result;
}

function getMessage(mode) {
    if (mode.length > 3) {
        return mode;
    }
    mode *= 1;
    let msg;
    switch (mode) {
        case 0: msg = "انجام شد"; break;


        case 5: msg = "چهره مشخصی در تصویر یافت نشد"; break;
        case 12: msg = "تشابه چهره با شماره پرسنلی متفاوت وجود دارد"; break;


        //  service errors
        case 239: msg = "اطلاعات مورد نظر یافت نشد"; break;

        //  DB errors
        case 241: msg = "داده ها ذخیره نشد"; break;
        case 242: msg = "داده مورد نظر یافت نشد"; break;

        //  disconnect or without result
        case 248: msg = "دستگاه مشابهی یافت نشد"; break;
        case 249: msg = "اقدام شد"; break;    //  device is restarting
        case 250: msg = "دستگاه قطع می باشد"; break;
        case 251: msg = "اطلاعات مورد نظر روی دستگاه نبود"; break;
        case 252: msg = "پاسخی از دستگاه دریافت نشد"; break;
        case 253: msg = "پاسخی از سرور دریافت نشد"; break;
        case 254: msg = "پاسخی از سرویس دریافت نشد"; break;
        case 255: msg = "سرویس مشغول است! بعداً اقدام کنید"; break;

        //  device errors
        default: msg = `"خطا ${mode} دستگاه"`; break;
    }
    return msg;
}

function highlightTableRow(tblName, code = 0) {
    const tableBody = document.getElementById(`body_${tblName}`);
    tableBody.querySelectorAll('tr.selectedtr').forEach((tr) => tr.classList.remove('selectedtr'));
    if (code != 0) {
        tableBody.querySelector(`tr[code='${code}']`).classList.add('selectedtr');
    }
}

function getSelectedTableItems(tblName, checkboxName) {
    let tr;
    let trCode;
    let items = [];
    const tableBody = document.getElementById(`body_${tblName}`);
    if (tableBody && (tableBody.innerHTML.length > 0)) {
        let flag = (checkboxName == undefined);
        tableBody.querySelectorAll('tr>td:first-child>input:checked').forEach(
            (item) => {
                tr = item.closest('tr');
                if (checkboxName) {
                    flag = (tr.querySelector(`td>input[name='${checkboxName}'].changed`) != undefined);
                }
                if (flag) {
                    trCode = tr.getAttribute('code');
                    items.push(trCode)
                }
            })
    }
    return items;
}

function filterNumber(section = document) {
    let inputType;
    let isDataNumber;
    let itemType;
    const isNumeric = (str) => /^\d+$/.test(str);
    section.querySelectorAll('input').forEach((item) => {
        if (item) {
            itemType = item.type;
            if ((itemType == 'number') || (itemType=='tel')) {
                item.addEventListener('beforeinput', (e) => {
                    inputType = e.inputType.toLowerCase();
                    if ((e.data) && ((inputType == 'inserttext') || (inputType == 'insertfrompaste'))) {
                        isDataNumber = isNumeric(e.data);
                        if (!isDataNumber) {
                            e.preventDefault();
                        }
                    }
                })
            }
        }
    })
}
