﻿
const getDevicePrsonBtn = document.getElementById('get_device_prson_btn');
const selectPersonBtn = document.getElementById('select_person_btn');
const save_db_Btn = document.getElementById('save_db_btn');
const removeFromDeviceBtn = document.getElementById('remove_from_device_btn');
const sendDeviceBtn = document.getElementById('send_device_btn');
const openOtherDevicesModalBtn = document.getElementById('open_other_devices_modal_btn');
const canselBtn = document.getElementById('cansel_btn');
const canselModalBtn = document.getElementById('cansel_modal_btn');
const getPrsonSelectedBtn = document.getElementById('prson_selected_btn');
const divMainTable = document.getElementById('div_person_data');
const selectedPersonPhoto = document.getElementById('selected_person_photo');
const divOtherDevice = document.getElementById('div_other_device');
const sendOtherDeviceBtn = document.getElementById('send_other_device_btn');
const removeFromOtherDeviceBtn = document.getElementById('remove_from_other_device_btn');
const canselOtherDeviceModalBtn = document.getElementById('cansel_other_device_modal_btn');

const btnCommands = [getDevicePrsonBtn, selectPersonBtn, save_db_Btn, removeFromDeviceBtn, sendDeviceBtn, openOtherDevicesModalBtn];
let isFromDB = false;
let isRecheckDevice = false;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    if (('ontouchstart' in document.body) && ((window.outerWidth <= 700) || (window.outerHeight <= 500))) {
        alert_error('');
        close();
        return;
    }
    deviceID = transferData[0] * 1;
    deviceSN = transferData[1];
    pageID = transferData[2] * 1;
    selectedPersonPhoto.src = '';
})

getDevicePrsonBtn.addEventListener('click', (e) => {
    isFromDB = false;
    deselectMainTable();
    cmdNum = 10;    //  runCommand(codes, showResult, end_function);
    runCommand('',
        (msg) => {
            if (msg.includes('<DocumentElement>')) {
                load_tbl_chb(msg, "device_person");
                $('#device_user_modal').modal({ backdrop: 'static', keyboard: false });
            } else {
                const message = getMessage(msg);
                alert_error(message);
            }
        },
        () => { });
})

selectPersonBtn.addEventListener('click', (e) => {
    isFromDB = true;
    deselectMainTable();
    open_form_('../../page/personnel/page_personnel_select.aspx', 'انتخاب افراد', "", "selectPerson_ok");
})

save_db_Btn.addEventListener('click', (e) => {
    const selectedPersonList = getSelectedTableItems('person_data');
    const personList = changedPersonData(selectedPersonList);
    if (personList.length > 0) {
        cmdNum = (isFromDB) ? 171 : 101;
        isRecheckDevice = false;
        clickedBtnCommand('اطلاعات شناسایی ☺ پرسنل ذخیره شد', personList);
    }
    selectedPersonList.forEach((item) => {
        divMainTable.querySelectorAll(`tr[code='${item}']>td>input.changed`).forEach((chb) => {
            chb.classList.toggle('checked');
            chb.classList.remove('changed');
        })
    })
})

removeFromDeviceBtn.addEventListener('click', (e) => {
    cmdNum = (isFromDB) ? 173 : 103;
    isRecheckDevice = true;
    clickedBtnCommand('حذف ☺ پرسنل انجام شد');
})

sendDeviceBtn.addEventListener('click', (e) => {
    let index = -1;
    let personList = [];
    const selectedPersonList = getSelectedTableItems('person_data');

    personList = getSelectedTableItems('person_data', 'enable');
    if (personList.length > 0) {
        personList.forEach((item) => {
            index = selectedPersonList.indexOf(item);
            if (index >= 0) {
                selectedPersonList.splice(index, 1);
            }
        })
        cmdNum = 105;
        clickedBtnCommand('وضعیت ☺ پرسنل تغییر داده شد', personList);
    }

    if (selectedPersonList.length > 0) {
        personList = changedPersonData(selectedPersonList);
        cmdNum = (isFromDB) ? 172 : 102;
        isRecheckDevice = true;
        clickedBtnCommand('اطلاعات شناسایی ☺ پرسنل ارسال شد', personList);
    }

    personList = getSelectedTableItems('person_data');
    personList.forEach((item) => {
        divMainTable.querySelectorAll(`tr[code='${item}']>td>input.changed`).forEach((chb) => {
            chb.classList.toggle('checked');
            chb.classList.remove('changed');
        })
    })
})

openOtherDevicesModalBtn.addEventListener('click', (e) => {
    const selectedPersonList = getSelectedTableItems('person_data');
    if (selectedPersonList.length > 0) {
        sendOtherDeviceBtn.disabled = true;
        removeFromOtherDeviceBtn.disabled = true;
        const query = `sn:'${deviceSN}'`;
        reqsvr("service/CommonTimmy.asmx/ReceiveSimilarDeviceTable", query, function (data) {
            if (data.d) {
                if (data.d.includes('<DocumentElement>')) {
                    load_tbl_chb(data.d, "other_device");
                    $('#other_device_modal').modal({ backdrop: 'static', keyboard: false });
                    let _sn;
                    cmdNum = 196;
                    divOtherDevice.querySelectorAll('#body_other_device > tr').forEach((tr) => {
                        _sn = tr.getAttribute('code');
                        runCommandWithSN(_sn, '', () => { }, () => { });
                    })
                } else {
                    const msg = getMessage(data.d);
                    alert_error(msg);
                }
            }
        });
    }
})

document.querySelectorAll('.modal .modal-header > button.close').forEach((btn) => {
    btn.addEventListener('click', (e) => canselCommand())
});

canselBtn.addEventListener('click', (e) => canselCommand())

canselModalBtn.addEventListener('click', (e) => {
    canselCommand();
    $('#device_user_modal').modal('hide');
})

getPrsonSelectedBtn.addEventListener('click', (e) => {
    const personList = getSelectedTableItems('device_person');
    let tableData = '';
    const temp = [];
    if (personList.length > 0) {
        resetPageParams();
        start_function(false);
        canselModalBtn.innerText = `توقف ${temp.length}/${personList.length}`;
        getPrsonSelectedBtn.classList.add('hide');
        canselModalBtn.classList.remove('hide');
        cmdNum = 15;
        personList.forEach((pid) => {
            //  runCommand(codes, showResult, end_function);
            runCommand(pid,
                (msg) => {
                    if (msg.includes('<DocumentElement>')) {
                        tableData = msg;
                        temp.push(1);
                        canselModalBtn.innerText = `توقف ${temp.length}/${personList.length}`;
                    } else {
                        const message = getMessage(msg);
                        alert_error(message);
                    }
                },
                () => {
                    if (tableData.includes('<DocumentElement>')) {
                        load_tbl_chb(tableData, "person_data");
                        convertTable_sortable();
                    }
                    end_function();
                    canselModalBtn.classList.add('hide');
                    getPrsonSelectedBtn.classList.remove('hide');
                    $('#device_user_modal').modal('hide');
                });
        })
    }
})

divMainTable.addEventListener('click', (e) => {
    const clickedItem = e.target;
    const clickedTD = clickedItem.closest('td');
    if (clickedTD) {
        const tr = clickedTD.parentElement;
        const img = tr.querySelector('img');
        selectedPersonPhoto.src = (img) ? img.src : '';
        if (clickedItem.tagName == 'INPUT') {
            let sideItem;
            if (clickedItem.name == 'admin') {
                clickedItem.classList.toggle('changed');
                if (!isFromDB) {
                    sideItem = clickedTD.nextElementSibling.firstChild;
                    if (!sideItem.checked) {
                        sideItem.checked = true;
                        sideItem.classList.toggle('changed');
                    }
                }
            }
            else if (clickedItem.name == 'enable') {
                if (!clickedItem.checked) {
                    sideItem = clickedTD.previousElementSibling.firstChild;
                    if (sideItem.checked) {
                        confirm_alert_msg(`مدیر دستگاه نمی تواند غیرفعال باشد. آیا تیک رتبه مدیر برداشته شود`,
                            () => {
                                sideItem.checked = false;
                                sideItem.classList.toggle('changed');
                                clickedItem.classList.toggle('changed');
                            },
                            () => clickedItem.checked = true)
                        return;
                    }
                }
                clickedItem.classList.toggle('changed');
            }
            let val = clickedTD.getAttribute('data-sort');
            val = (val === '1') ? '0' : '1';
            clickedTD.setAttribute('data-sort', val);
        }
    }
})

divOtherDevice.addEventListener('click', (e) => {
    const clickedItem = e.target;
    if (clickedItem.tagName == 'INPUT') {
        const deviceList = getSelectedTableItems('other_device');
        sendOtherDeviceBtn.disabled = (deviceList.length == 0);
        removeFromOtherDeviceBtn.disabled = (deviceList.length == 0);
    }
})

canselOtherDeviceModalBtn.addEventListener('click', (e) => {
    canselCommand();
    $('#other_device_modal').modal('hide');
})

sendOtherDeviceBtn.addEventListener('click', (e) => {
    cmdNum = (isFromDB) ? 172 : 102;
    runCommandOnOtherDevice();
})

removeFromOtherDeviceBtn.addEventListener('click', (e) => {
    cmdNum = (isFromDB) ? 173 : 103;
    runCommandOnOtherDevice();
})

document.querySelectorAll('#container > main > article > div.btn-group-vertical > button').forEach((btn) => {
    btn.addEventListener('click', (e) => {
        const personSelected = getSelectedTableItems('person_data');
        if (personSelected.length == 0) {
            alert_error('موردی انتخاب نشده است');
        }
    })
});

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function deselectMainTable() {
    selectedPersonPhoto.src = '';
    parent.sel_prow = '';
    divMainTable.querySelectorAll('table > tbody > tr.selectedtr').forEach((tr) => tr.classList.remove('selectedtr'));
}

function resetPageParams() {
    divMainTable.innerHTML = '';
    save_db_Btn.disabled = true;
    removeFromDeviceBtn.disabled = true;
    sendDeviceBtn.disabled = true;
    openOtherDevicesModalBtn.disabled = true;
}

function end_function() {
    canselBtn.classList.add('hide');
    btnCommands.forEach((btnCmd) => {
        btnCmd.disabled = false;
    })
}

function start_function(isShow_canselBtn = true) {
    if (isShow_canselBtn) {
        canselBtn.classList.remove('hide');
    }
    btnCommands.forEach((btnCmd) => {
        btnCmd.disabled = true;
    })
}

function changedPersonData(selectedPersonList) {
    const personList = [];
    let data = '';
    selectedPersonList.forEach((pid) => {
        let person_name = '';
        let admin = '';
        let password = '';
        let card = '';
        divMainTable.querySelectorAll(`tr[code='${pid}'] > td > input`).forEach((item) => {
            switch (item.name) {
                case 'person_name': person_name = item.value; break;
                case 'admin': admin = (item.checked) ? 1 : 0; break;
                case 'password': password = item.value; break;
                case 'card': card = item.value; break;
            }
        })
        data = `pid:${pid}☻name:${person_name}☻admin:${admin}☻password:${password}☻card:${card}`;
        personList.push(data);
    })
    return personList;
}

function clickedBtnCommand(endMessage, personList) {
    personList = (personList) ? personList : getSelectedTableItems('person_data');
    let lastMessage;
    const checkedList = [];
    if (personList.length > 0) {
        canselBtn.innerText = `توقف ${checkedList.length}/${personList.length}`;
        start_function();
        personList.forEach((persondata) => {
            //  runCommand(codes, showResult, end_function);
            runCommand(persondata,
                (msg, _code) => {
                    let data = _code;
                    if (msg == '0') {
                        if (!checkedList.includes(_code)) {
                            checkedList.push(_code)
                        }
                        if (_code.includes('☻')) {
                            data = _code.split('☻')[0].split(':')[1];
                        }
                        highlightTableRow('person_data', data);
                        selectedPersonPhoto.src = '';
                        document.querySelectorAll(`#body_person_data > tr[code='${data}'] > td > img`).forEach((img) => selectedPersonPhoto.src = (img.src.length > 5) ? img.src : '');
                        canselBtn.innerText = `توقف ${checkedList.length}/${personList.length}`;
                    }
                    else {
                        lastMessage = getMessage(msg);
                    }
                },
                () => {
                    end_function();
                    setTimeout(() => {
                        highlightTableRow('person_data');
                        selectedPersonPhoto.src = '';
                        if (isRecheckDevice) {  //  Service parameters update
                            cmdNum = 196;
                            runCommand('', () => { }, () => { });
                            isRecheckDevice = false;
                        }
                    }, 1000);
                    if (checkedList.length > 0) {
                        const parts = endMessage.split('☺');
                        alert_success(`${parts[0]} ${checkedList.length} ${parts[1]}`);
                    } else {
                        alert_error(lastMessage);
                    }
                }
            );
        })
    }
}

function selectPerson_ok() {
    if (parent.sel_prow.length > 0) {
        resetPageParams();
        start_function();
        const query = `sn:'${deviceSN}',codes:'${parent.sel_prow}',pageID:${pageID}`;
        reqsvr("service/CommonTimmy.asmx/GetPersonFromDB", query, function (data) {
            if (data.d) {
                if (data.d.includes('<DocumentElement>')) {
                    load_tbl_chb(data.d, "person_data");
                    convertTable_sortable();
                    end_function();
                } else {
                    const msg = getMessage(data.d);
                    alert_error(msg);
                }
            }
        });
    }
}

function convertTable_sortable() {
    const table = divMainTable.querySelector('table');
    filterNumber(table);
    if (!table) return;
    table.classList.add('sortable');
    const no_sort_cols = (isFromDB) ? [0, 1, 4, 6, 7, 8, 9] : [0, 1, 4, 7, 8, 9];
    const cols = table.querySelectorAll('thead>tr>th');
    for (let i of no_sort_cols) {
        cols[i].classList.add('no-sort');
    }
    const tick_cols = (isFromDB) ? ['admin'] : ['admin', 'enable'];
    for (let n of tick_cols) {
        table.querySelectorAll(`tbody>tr>td>input[name='${n}']`).forEach((item) => item.parentElement.setAttribute('data-sort', (item.checked) ? '1' : '0'));
    }
}

function runCommandOnOtherDevice() {
    const selectedPersonList = getSelectedTableItems('person_data');
    const selectedDeviceList = getSelectedTableItems('other_device');
    if ((selectedPersonList.length > 0) && (selectedDeviceList.length > 0)) {
        let lastMessage;
        let checkedList = {};
        document.querySelectorAll(`#body_other_device>tr`).forEach((tr) => {
            tr.querySelector('td:first-child>input').disabled = true;
            tr.querySelector('td:last-child').innerHTML = '';
        })
        sendOtherDeviceBtn.disabled = true;
        removeFromOtherDeviceBtn.disabled = true;
        const personDataList = changedPersonData(selectedPersonList);
        let personData;
        for (let sn of selectedDeviceList) {
            checkedList[sn] = [];
            for (let pid of selectedPersonList) {
                if ((cmdNum == 102) || (cmdNum == 172)) {
                    personData = personDataList.find((item) => item.includes(`pid:${pid}`));
                } else {
                    personData = pid;
                }
                runCommandWithSN(sn, personData,
                    (msg, _code, _sn) => {
                        const message = getMessage(msg);
                        let _pid = _code;
                        if (_code.includes('☻')) {
                            _pid = _code.split('☻')[0].split(':')[1];
                        }
                        if (msg == '0') {
                            if (!checkedList[_sn].includes(_pid)) {
                                checkedList[_sn].push(_pid)
                            }
                            highlightTableRow('other_device', _sn);
                        }
                        else {
                            lastMessage = message;
                        }
                        document.querySelector(`#body_other_device>tr[code='${_sn}']>td:last-child`).
                            innerHTML = (checkedList[_sn].length == 0) ? message : `تعداد موارد انجام شده: ${checkedList[_sn].length}/${selectedPersonList.length}`;
                    },
                    () => {
                        setTimeout(() => highlightTableRow('other_device'), 1000);
                        let counter = 0
                        cmdNum = 196;
                        selectedDeviceList.forEach((_sn) => {
                            runCommandWithSN(_sn, '', () => { }, () => { });
                            counter += checkedList[_sn].length
                        });
                        if (counter > 0) {
                            alert_success(`تعداد ${counter} مورد انجام شد`);
                        } else {
                            alert_error(lastMessage);
                        }
                        document.querySelectorAll(`#body_other_device>tr>td:first-child>input`).forEach((chb) => chb.disabled = false);
                        sendOtherDeviceBtn.disabled = false;
                        removeFromOtherDeviceBtn.disabled = false;
                        checkedList = {};
                    }
                )
            }
        }
    }
}

