﻿
const nameDevBox = document.getElementById('name_dev_box');
const numberDevBox = document.getElementById('number_dev_box');
const snBox = document.getElementById('sn_box');
const ipBox = document.getElementById('ip_box');
const saveBtn = document.getElementById('save_btn');
const checkBtn = document.getElementById('check_btn');

let deviceName = '';
const parameterList = ['number_dev_box'];
const changedParameters = [];


///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        //parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    if (('ontouchstart' in document.body) && ((window.outerWidth <= 700) || (window.outerHeight <= 500))) {
        alert_error('');
        close();
        return;
    }
    deviceSN = transferData[0];
    deviceName = transferData[1];
    nameDevBox.value = deviceName;
    snBox.value = deviceSN;
    parameterList.forEach((id) => {
        document.getElementById(id).addEventListener('input', (e) => {
            if (!changedParameters.includes(id)) {
                changedParameters.push(id);
            }
        })
    })
    load();
})

saveBtn.addEventListener('click', (e) => {
    let param = nameDevBox.value.trim();
    nameDevBox.value = param;
    const isError = check_force_error('#container');
    if (isError) return;
    let query;
    if (deviceName != param) {
        deviceName = param;
        query = `sn:'${deviceSN}',deviceName:'${deviceName}'`;
        reqsvr("DeviceSettingsForm.aspx/SaveDeviceName", query, function (data) {
            if (data.d == 1) {
                if (changedParameters.length > 0) {
                    setDevInfo();
                } else {
                    alert_success('انجام شد');
                }
            } else {
                alert_error('ذخیره نشد');
            }
        });
    }
})

checkBtn.addEventListener('click', (e) => {
    load();
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function load() {
    checkBtn.classList.add('hide');
    //freezeParams(true);
    //runCommand(codes, showResult, getDevInfo);

}

function getDevInfo() {
    //reqsvr(getip_devinfo){fillParams}
}

function fillParams() {
    //
    //
    freezeParams(false);
}

function setDevInfo() {
    alert_error('پیاده نشده');
    //freezeParams(true);
    //cmdNum = 13;
    //let codes = '؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟؟';
    //runCommand(codes,
    //    (result) => {
    //        checkBtn.classList.remove('hide');
    //        const msg = `<p>${result}</p><p>برای بررسی تنظیمات از دکمه مربوطه استفاده کنید</p>`;
    //            alert_message(msg);
    //    },
    //    () => freezeParams(false));
}

function freezeParams(isDisable) {
    const idList = ['save_btn', 'check_btn', 'name_dev_box', ...parameterList];
    idList.forEach((id) => document.getElementById(id).disabled = isDisable);
}

