﻿
const deviceList = document.getElementById('device_list');
const btnCommands = document.querySelectorAll('article > section > button');
const alarmLocation = document.querySelector('#container > footer');
const getAllLogBtn = document.getElementById('get_all_log_btn');
const canselBtn = document.getElementById('cansel_btn');

let allDevices = '';
let codes = '';
let deviceName = '';
let timeoutPointer;
let serviceStatus = '';
let connectStatus = -1;
let startDate = '';
let endDate = '';
let all_logs;
let saved_logs;
let _logPartCount = 0;
const logNumber = 13;

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
     initial_date_ok = true;
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 550);
        //parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    if (('ontouchstart' in document.body) && ((window.outerWidth <= 700) || (window.outerHeight <= 500))) {
        alert_error('');
        close();
        return;
    }
    refreshDates();

    reqsvr("service/CommonTimmy.asmx/ReceiveDeviceList", "", function (data) {
        if (data.d) {
            allDevices = data.d;
            load_cb("#device_list", data.d);
            selectedDevice();
        } else {
            close();
        }
    });

})

deviceList.addEventListener('change', (e) => {
    clearTimeout(timeoutPointer);
    selectedDevice();
})

btnCommands.forEach((btn) => {
    btn.addEventListener('click', (e) => {
        const clickedItem = e.target;
        switch (clickedItem.id) {
            case 'reboot_btn': cmdNum = 1; break;
            case 'clean_admin_btn': cmdNum = 4; break;
            case 'clean_log_btn': cmdNum = 6; break;
            case 'set_time_btn':
                {
                    let message = '';
                    cmdNum = 11;    //  runCommand(codes, showResult, end_function);
                    runCommand(codes,
                        (msg) => message = `<p>${getMessage(msg)}<br/>آیا مایلید ساعت دستگاه با سیستم تنظیم شود؟</p>`,
                        () => confirm_alert_msg(message, setDeviceTime, empty_function));
                }
                return;
            case 'get_dates_btn':
                startDate = '';
                endDate = '';
                all_logs = 0;
                document.querySelectorAll('.date').forEach((item) => item.value = '');
                $('#get_dates_modal').modal('show');
                return;
            case 'prson_manage_btn':    //  open_form_(url, title, param, callback, callbackclose)
                {
                    const _url = "page/device/Tiam/PersonManageTiam.aspx";
                    const _title = `مدیریت پرسنل ${(deviceName.startsWith('دستگاه')) ? '' :'دستگاه '}${deviceName}`;
                    assignPageID();
                    let _param = `${deviceID}&${deviceSN}&${pageID}`;
                    if ((pageID > 0) && (pageID <= 50000)) {
                        open_form_(_url, _title, _param, '', 'removePageID');
                    } else {
                        _param = getMessage((pageID == 0) ? 255 : 250);
                        alert_error(_param);
                        pageID = 0;
                    }
                }
                return;
            case 'open_setting_form_btn':    //  open_form_(url, title, param, callback, callbackclose)
                {
                    const _url = "page/device/Tiam/DeviceSettingsForm.aspx";
                    const _title = `تنظیمات ${(deviceName.startsWith('دستگاه')) ? '' : 'دستگاه '}${deviceName}`;
                    let _param = `${deviceSN}&${deviceName}`;
                    open_form_(_url, _title, _param, '', 'empty_function');
                }
                return;
            case 'open_camera_tiam_btn':    //  open_form_(url, title, param, callback, callbackclose)
                {
                    const _url = "page/device/Tiam/CameraCropTiam.aspx";
                    const _title = 'فرم اتصال دوربین به دستگاه';
                    open_form_(_url, _title, '', '', 'empty_function');
                }
                return;
            case 'show_specifications_btn':
                const query = `sn:'${deviceSN}'`;
                reqsvr("service/CommonTimmy.asmx/ReceiveDeviceSpecifications", query, function (data) {
                    if (data.d) {
                        const pre = `<pre style="text-align: right;">${data.d}</pre>`;
                        const title = `مشخصات ${(deviceName.startsWith('دستگاه')) ? '' : 'دستگاه '}${deviceName}`;
                        alert_message(pre, title);
                    }
                });
                return;
            default: return;
        }    //  runCommand(codes, showResult, end_function);
        runCommand(codes,
            (msg) => {
                const message = getMessage(msg);
                alert_message(message);
            },
            empty_function);
    })
})

getAllLogBtn.addEventListener('click', (e) => {
    const checkAllDates = checkDates();
    if (checkAllDates) {
        const query = `${startDate}&${endDate}`;
        cmdNum = 12;
        runCommand(query,
            (msg) => {
                if (!msg.includes('all_logs')) {
                    const message = getMessage(msg);
                    alarmLocation.innerText = message;
                    alert_error(message);
                    return;
                }
                all_logs = msg.replace('all_logs', '') * 1;
                if (all_logs == 0) {
                    alarmLocation.innerText = `هیچ ترددی یافت نشد`;
                    return;
                }
                saved_logs = 0;
                _logPartCount = Math.ceil(all_logs / logNumber);
                alarmLocation.innerText = `${saved_logs}/${all_logs}`;
                canselBtn.classList.remove('hide');
            },
            () => {
                if (all_logs > 0) {
                    savePartLog();
                }
            });
        $('#get_dates_modal').modal('hide');
    }
})

canselBtn.addEventListener('click', (e) => {
    if (_logPartCount > 1) {
        _logPartCount = 1;
    }
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function empty_function() { }

function selectedDevice() {
    var selectedRow = search_xml(allDevices, deviceList.value);
    deviceSN = $(selectedRow).find("serial").text();
    deviceName = $(selectedRow).find("name").text();
    serviceStatus = '';
    checkDeviceConnection();
}

function assignPageID() {
    const query = `sn:'${deviceSN}'`
    reqsvrS("service/CommonTimmy.asmx/AssignPageID", query, function (data) {
        if (data.d) {
            pageID = data.d * 1;
        }
    });
}

function removePageID() {
    const query = `id:${pageID}`;
    reqsvr("service/CommonTimmy.asmx/RemovePageID", query, function (data) {
        if (data.d) {
            if (data.d == 'ok') {
                pageID = 0;
                return;
            }
        }
        alert_error(data.d);
    });
}

function checkDeviceConnection() {
    const query = `oldRespLen:${serviceStatus.length}`;
    reqsvr2("service/CommonTimmy.asmx/CheckConnections", query, function (data) {
        if (data.d) {
            if ((serviceStatus != data.d) || (deviceID != deviceList.value)) {
                serviceStatus = data.d;
                let isChanged = false;
                if (serviceStatus.includes('no_change')) {
                    return;
                }
                else if (serviceStatus.includes('-1')) {
                    btnCommands.forEach((btnCmd) => btnCmd.disabled = true);
                    alarmLocation.classList.remove('bg-red', 'bg-green', 'bg-wheit');
                    alert_error('سرویس متوقف شده است');
                    alarmLocation.classList.add('bg-red');
                    alarmLocation.innerText = 'دستگاه قطع می باشد';
                    isChanged = true;
                    deviceList.querySelectorAll('option').forEach((item) => item.classList.remove('bg-green'));
                    deviceID = deviceList.value;
                } else {
                    const dataArray = serviceStatus.split('&');
                    let parts;
                    dataArray.forEach((item) => {
                        parts = item.split(':');
                        isChanged = UpdateDeviceConnection(parts[0], parts[1]) || isChanged;
                    })
                }
                if (isChanged) {
                    $('#device_list').selectpicker('refresh');
                }
            }
        }
    });
    timeoutPointer = setTimeout(() => {
        checkDeviceConnection();
    }, 2000);
}

function UpdateDeviceConnection(devNum, status) {
    let isChanged = false;
    if (devNum == deviceList.value) {
        if ((deviceID != devNum) || (connectStatus != status)) {
            deviceID = devNum;
            connectStatus = status;
            btnCommands.forEach((btnCmd) => btnCmd.disabled = true);
            alarmLocation.classList.remove('bg-red', 'bg-green', 'bg-wheit');
            switch (status) {
                case '0':
                    alarmLocation.classList.add('bg-red');
                    alarmLocation.innerText = 'دستگاه قطع می باشد';
                    break;
                case '1':
                    alarmLocation.classList.add('bg-green');
                    alarmLocation.innerText = 'دستگاه متصل می باشد';
                    btnCommands.forEach((btnCmd) => btnCmd.disabled = false);
                    break;
                default:
                    alarmLocation.classList.add('bg-wheit');
                    alarmLocation.innerText = 'خطا رخ داده است';
                    break;
            }
        }
    }
    deviceList.querySelectorAll(`option[value='${devNum}']`).forEach((item) => {
        isChanged = (item.classList.contains('bg-green') != (status == 1));
        if (isChanged) {
            item.classList.toggle('bg-green');
        }
    })
    return isChanged;
}

function savePartLog(code = '') {
    cmdNum = 17;
    runCommand(code,
        (msg) => {
            if (!msg.includes('saved_logs')) {
                _logPartCount = 0;
                const message = getMessage(msg);
                alert_error(message);
                return;
            }
            saved_logs = msg.replace('saved_logs', '') * 1;
            alarmLocation.innerText = `${saved_logs}/${all_logs}`;
        },
        () => {
            if (_logPartCount > 0) {
                _logPartCount--;
                const param = (_logPartCount == 0) ? '0' : '';
                savePartLog(param);
            } else {
                canselBtn.classList.add('hide');
            }
        }
    );
}

function setDeviceTime() {
    let message = '';
    cmdNum = 2;    //  runCommand(codes, showResult, end_function);
    runCommand(codes,
        (msg) => message = getMessage(msg),
        () => alert_message(message));
}

///////////////////////////////////////////////////////
// functions for date
///////////////////////////////////////////////////////

function refreshDates() {
    const dateObjects = [];
    const allDate = document.querySelectorAll('.date');
    for (var i = 0; i < allDate.length; i++) {
        const el = allDate[i];
        dateObjects[i] = new PesianDate.persianCalendar(el.id, {
            onchange: function (pdate) {
                if (pdate) {
                    changedDate(el);
                    checkDates();
                }
            }
        })
    }
    initial_date_mask();
}

function changedDate(dateElement) {
    const date = dateElement.value;
    const id = dateElement.id;
    switch (id) {
        case 'start-date':
            startDate = date;
            break;

        case 'end-date':
            endDate = date;
            break;
    }
}

function checkDates() {
    let isCorrect = false;
    if (startDate && endDate) {
        isCorrect = CMPDay(startDate, endDate, startDate);
        if (isCorrect == false) {
            alert_error("ترتیب تاریخ ها رعایت نشده است ");
        }
    }
    return isCorrect;
}
