﻿
const profileSavingBtn = document.getElementById('profile_saving_btn');
const cameraBtn = document.getElementById('camera_btn');
const sendBtn = document.getElementById('send_btn');
const pidBox = document.getElementById('pid_box');
const nameBox = document.getElementById('name_box');
const divTable = document.getElementById('div_device_ai');
const photo = document.getElementById('photo');


const person = {};
let serviceStatus = '';
let xmlPerson = '';
let snList = [];
let imageName = '';

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    let transferData;
    if (mode_form) {
        transferData = initial_page(700, 500);
        //parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    reqsvr("CameraCropTiam.aspx/ReceivePersonList", "", function (data) {
        if (data.d) {
            xmlPerson = data.d;
            checkDeviceConnection();
        }
    });
    filterNumber(pidBox.parentElement);
})

cameraBtn.addEventListener('click', (e) => {
    divTable.querySelectorAll(`tr>td:last-child`).forEach((item) => item.innerHTML = '');
    resetParams(person.id);
})

pidBox.addEventListener('input', (e) => {
    let pid = e.target.value;
    if (pid == 0) {
        pid = '';
    }
    getName(pid);
})

divTable.addEventListener('click', (e) => {
    const clickedItem = e.target;
    if (clickedItem.tagName == 'INPUT') {
        snList = getSelectedTableItems('device_ai');
        sendBtn.disabled = ((imageName.length == 0) || (snList.length == 0) || (person.id.length == 0));
        if (snList.length) {
            sendBtn.classList.remove('invisible');
        }
    } else {
        const tr = clickedItem.closest('tr');
        if (tr == null) return;
        let td_th = tr.firstElementChild;
        if ((td_th.tagName != 'TH') && (td_th.tagName != 'TD')) return;
        td_th = (td_th.tagName == 'TH') ? clickedItem.closest('th') : clickedItem.closest('td');
        if ((td_th == null) || (td_th != tr.firstElementChild) || (td_th.firstElementChild.tagName != 'INPUT')) return;
        td_th.firstElementChild.click();
    }
})

sendBtn.addEventListener('click', (e) => {
    let isError = check_force_error('#container');
    isError = (isError || (imageName.length == 0) || (person.id.length == 0));
    if (isError) return;
    const codes = `${person.id}☺${imageName}`;
    const transferedSN = [];
    cmdNum = 20;
    deviceID = 0;
    snList.forEach((sn) => {
        deviceSN = sn
        runCommand(codes,
            (msg, _code, _sn) => {
                if (msg == 0) {
                    transferedSN.push(_sn);
                }
                divTable.querySelector(`tr[code='${_sn}']>td:last-child`).innerHTML = getMessage(msg);
            },
            () => {
                let query = `imageName:\"${imageName}\"`;
                reqsvr("CameraCropTiam.aspx/RemoveImage", query, function (data) {
                    confirm_alert_msg(
                        `<div>تعداد ارسالی : ${transferedSN.length}</div><div>عدم ارسال : ${snList.length - transferedSN.length}</div><div>آیا مایل به ارسال چهره پرسنل جدید هستید؟</div>`,
                        () => {
                            resetParams('');
                            setTimeout(() => pidBox.focus(), 800);
                        },
                        () => { })
                });
            }
        );
    })
})

profileSavingBtn.addEventListener('click', (e) => {
    let query = `imageName:\"${imageName}\",`;
    query += `pid:${person.id}`;
    reqsvr("CameraCropTiam.aspx/SaveProfile", query, function (data) {
        if (data.d) {
            alert_success('انجام شد');
            profileSavingBtn.classList.add('invisible');
            profileSavingBtn.disabled = true;
        } else {
            alert_error('');
        }
    });
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

function checkDeviceConnection() {
    const query = `oldRespLen:${serviceStatus.length}`;
    reqsvr2("service/CommonTimmy.asmx/CheckConnections", query, function (data) {
        if (data.d) {
            if (serviceStatus != data.d) {
                serviceStatus = data.d;
                pidBox.disabled = serviceStatus.includes('-1');
                if (pidBox.disabled) {
                    resetParams('');
                    alert_error('سرویس متوقف شده است');
                }
            }
        }
    });
    setTimeout(() => checkDeviceConnection(), 2000);
}

function receive_output(data, id) {    //  data: image path or data    id: The id of the clicked item
    if ((id != cameraBtn.id) || (!data.startsWith('files/temp/')) || (!data.endsWith('.jpg'))) return;
    photo.src = `../../../${data}`;
    photo.classList.remove('invisible');
    imageName = data.split('.')[0].split('/').pop();
    profileSavingBtn.classList.remove('invisible');
    profileSavingBtn.disabled = ((imageName.length == 0) || (person.id.length == 0));
    const query = `imageName:\"${imageName}\"`;
    reqsvr("CameraCropTiam.aspx/ReceiveDeviceList", query, function (data) {
        if (data.d) {
            if (divTable.innerHTML.length) {
                sendBtn.disabled = ((imageName.length == 0) || (snList.length == 0) || (person.id.length == 0));
            } else {
                load_tbl_chb(data.d, "device_ai");
            }
        } else {
            alert_error('دستگاه متناسب یافت نشد');
            //close();
        }
    });
}

function getName(pid) {
    let name = '';
    if (pid.length > 0) {
        var selectedRow = search_xml(xmlPerson, pid);
        name = $(selectedRow).find("name").text();
        cameraBtn.classList.remove('invisible');
    } else {
        pidBox.value = pid;
    }
    pidBox.classList.toggle('red_border', (pid.length == 0));
    cameraBtn.disabled = (pid.length == 0);
    sendBtn.disabled = ((imageName.length == 0) || (snList.length == 0) || (pid.length == 0));
    profileSavingBtn.disabled = ((profileSavingBtn.classList.contains('invisible')) || (imageName.length == 0) || (pid.length == 0));
    nameBox.innerText = (name.length > 0) ? name : '...';
    person.id = pid;
    person.name = name;
}

function resetParams(pid) {
    getName(pid);
    imageName = '';
    photo.src = '#';
    photo.classList.add('invisible');
    sendBtn.disabled = true;
    profileSavingBtn.disabled = true;
}
