﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PersonManageTiam.aspx.cs" Inherits="TimeWork.page.DeviceConnection.PersonManageTiam" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link href="sort_table/sortable.css" rel="stylesheet" />
    <link href="../../../style/Bootstrap/bootstrap.min.css" rel="stylesheet" />
    <link href="../../../style/Bootstrap/bootstrap-rtl.css" rel="stylesheet" />
    <link href="../../../style/alert/sweetalert.css" rel="stylesheet" />
    <link href="../../../style/select/bootstrap-select.css" rel="stylesheet" />
    <link href="../../../style/Treeview/Treeview.css" rel="stylesheet" />
    <link href="../../../style/timepicker/bootstrap-clockpicker.css" rel="stylesheet" />
    <link href="../../../style/calendar/js-persian-cal.css" rel="stylesheet" />
    <link href="../../../style/sanaco.css" rel="stylesheet" />

    <script src="sort_table/sortable.js"></script>
    <script src="../../../script/jquery.min.js" type="text/javascript"></script>
    <script src="../../../style/Bootstrap/bootstrap.min.js"></script>
    <script src="../../../style/alert/sweetalert.js"></script>
    <script src="../../../style/Treeview/Treeview.js"></script>
    <script src="../../../style/select/bootstrap-select.js"></script>
    <script src="../../../style/mask/jquery.mask.min.js"></script>
    <script src="../../../style/timepicker/bootstrap-clockpicker.min.js"></script>
    <script src="../../../style/calendar/js-persian-cal.min.js"></script>
    <script src="../../../script/fnc.js"></script>

    <%--Attachment css--%>
    <link href="css/personManageTiam.css" rel="stylesheet" />
</head>
<body>
    <div id="container">
        <header>
            <div class="btn-group">
                <button type="button" id="get_device_prson_btn" class="btn btn-default">فراخوانی از دستگاه</button>
                <button type="button" id="select_person_btn" class="btn btn-default">فراخوانی از بانک اطلاعاتی</button>
            </div>
        </header>

        <main>
            <article>
                <div class="btn-group-vertical">
                    <button type="button" disabled="disabled" id="save_db_btn" class="btn btn-default">ذخیره در بانک اطلاعاتی</button>
                    <button type="button" disabled="disabled" id="remove_from_device_btn" class="btn btn-default">حذف از دستگاه</button>
                    <button type="button" disabled="disabled" id="send_device_btn" class="btn btn-default">ارسال روی دستگاه</button>
                    <button type="button" disabled="disabled" id="open_other_devices_modal_btn" class="btn btn-default">ارسال روی سایر دستگاه ها</button>
                </div>
                <button type="button" id="cansel_btn" class="btn btn-info btn-block hide">توقف</button>
                <footer id="bottom_buttons">
                    <div class="image-background">
                        <img id="selected_person_photo" src="#" />
                    </div>
                </footer>
            </article>

            <div>
                <div id="div_person_data"></div>
                <footer id="bottom_person_data">
                </footer>
            </div>
        </main>
    </div>

    <section>
        <div id="device_user_modal" class="modal fade unselectable" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><span class="fa fa-close"></span></button>
                    <h5 class="modal-title">لیست پرسنل روی دستگاه</h5>
                </div>
                <div class="modal-body">
                    <aside>
                        <div id="div_device_person"></div>
                        <button type="button" id="prson_selected_btn" class="btn btn-success">تایید</button>
                        <button type="button" id="cansel_modal_btn" class="btn btn-info hide"></button>
                    </aside>
                </div>
            </div>
        </div>
    </div>

    <div id="other_device_modal" class="modal fade unselectable" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><span class="fa fa-close"></span></button>
                    <h5 class="modal-title">دستگاه های مرتبط</h5>
                </div>
                <div class="modal-body">
                    <aside>
                        <div id="div_other_device"></div>
                        <div class="modal-bottom btn-group">
                            <button type="button" id="send_other_device_btn" class="btn btn-success">ارسال</button>
                            <button type="button" id="remove_from_other_device_btn" class="btn btn-danger">حذف</button>
                            <button type="button" id="cansel_other_device_modal_btn" class="btn btn-info">انصراف</button>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>
    </section>

    <%--Attachments js--%>
    <script src="js/timmyPages.js"></script>
    <script src="js/personManageTiam.js"></script>
</body>
</html>
