﻿
let outputType = '';        // file or data(base64)
let usedMask = false;       // setting a mask on video
let minCroppedSize = 300;   // Minimum cropped photo size
let aspectRatio = 1;        // The aspect ratio of the crop box
let autoCropArea = 0.8;     // Define the percentage of automatic cropping area when initializes
const video = document.getElementById('video');
const imageRepair = document.getElementById('image-repair')
const snapshotBtn = document.getElementById('btn_snapshot');
const imageEditButtons = document.querySelector('.image-edit-buttons');
let canvas;
let myCropper;
let base64data;
let videoStream;
let transferData;
let mainImagePath;
let isCameraOn = false;
let facingMode = 'user';

///////////////////////////////////////////////////////
// events
///////////////////////////////////////////////////////

window.addEventListener('load', (e) => {
    if (mode_form) {
        transferData = initial_page(650, 700);
        parent.win.maximize();
    } else {
        transferData = initial_tab();
    }
    outputType = (transferData[0].length) ? transferData[0] : '';
    usedMask = (transferData[1] == 1);
    minCroppedSize = (transferData[2] >= 50) ? transferData[2] : 300;
    aspectRatio = (transferData[3] > 0) ? transferData[3] : 1;
    autoCropArea = ((transferData[4] > 0) && (transferData[4] < 1)) ? transferData[4] : 0.8;
    configCamera();
    setTimeout(() => {
        if (!isCameraOn) {
            close();
        }
    }, 5000)
    configCropper();
})

window.addEventListener('resize', (e) => {
    if (myCropper) {
        myCropper.reset();
    }
})

document.getElementById('switch_camera').addEventListener('click', (e) => {
    facingMode = (facingMode == 'user') ? 'environment' : 'user';
    document.querySelectorAll('.mask_canvas').forEach((item) => item.remove());
    configCamera();
})

snapshotBtn.addEventListener('click', (e) => {
    const cameraCanvas = document.getElementById('camera-canvas');
    cameraCanvas.classList.remove('hide');
    cameraCanvas.width = video.videoWidth;
    cameraCanvas.height = video.videoHeight;
    cameraCanvas.getContext('2d').drawImage(video, 0, 0);

    mainImagePath = cameraCanvas.toDataURL('image/jpeg', 0.92);
    $('#btn_snapshot').prop('disabled', true);
    myCropper.replace(mainImagePath);
    $('#cropper-section').removeClass("hide");
    $('#camera-section').addClass("hide");
    stopStream();
    if ((autoCropArea < 1) && (autoCropArea > 0)) {
        setTimeout(() => imageEditButtons.querySelector('button[name=ok-crop-btn]').click(), 100);
    }
})

imageEditButtons.addEventListener('click', (e) => {

    let clickedItem = e.target;
    if (clickedItem.tagName == 'DIV') {
        return;
    }
    if (clickedItem.tagName == 'I') {
        clickedItem = clickedItem.parentElement;
    }

    switch (clickedItem.name) {

        case 'save-image-btn':
            if ((outputType.length) && (base64data)) {
                if (outputType.toLowerCase() == 'data') {
                    savingDone(`'${base64data}'`);
                } else {
                    const fileName = (new Date()).getTime();
                    let query = `fileName:\"${fileName}\",`;
                    query += `base64data:\"${base64data}\"`;
                    reqsvr("CameraPhotoCropping.aspx/ImageStorage", query, function (data) {
                        if (data.d) {
                            savingDone(`'files/temp/${fileName}.jpg'`);
                        } else {
                            alert_error('');
                        }
                    });
                }
            }
            break;

        case 'reset-image-btn':
            imageEditButtons.classList.remove('cropped');
            myCropper.replace(mainImagePath);
            imageEditButtons.querySelectorAll('.flip').forEach((item) => {
                item.classList.remove('flip');
            })
            myCropper.reset();
            myCropper.clear();
            break;

        case 'move-btn':
            myCropper.setDragMode('move');
            imageEditButtons.querySelector('button[name=crop-btn]').classList.remove('clicked');
            clickedItem.classList.add('clicked');
            break;

        case 'crop-btn':
            myCropper.clear();
            myCropper.setDragMode('crop');
            imageEditButtons.querySelector('button[name=move-btn]').classList.remove('clicked');
            clickedItem.classList.add('clicked');
            break;

        case 'zoom-in-btn':
            myCropper.zoom(0.1);
            break;

        case 'zoom-out-btn':
            myCropper.zoom(-0.1);
            break;

        case 'rotate-left-btn':
            myCropper.rotate(-90);
            break;

        case 'rotate-right-btn':
            myCropper.rotate(90);
            break;

        case 'flip-horizontal-btn':
            clickedItem.classList.toggle('flip');
            myCropper.scaleX((clickedItem.classList.contains('flip')) ? -1 : 1);
            break;

        case 'flip-vertical-btn':
            clickedItem.classList.toggle('flip');
            myCropper.scaleY((clickedItem.classList.contains('flip')) ? -1 : 1);
            break;

        case 'ok-crop-btn':
            let { width, height } = myCropper.getData();
            width = Math.floor(width);
            height = Math.floor(height);
            if ((width < minCroppedSize) || (height < minCroppedSize)) {
                alert_error(`ابعاد قسمت برش خورده(${width} * ${height})، کوچکتر از استاندارد است.<br/>حداقل ابعاد تصویر نباید از  ${minCroppedSize} کوچکتر باشد.`);
                return;
            }

            canvas = myCropper.getCroppedCanvas({
                fillColor: '#fff',
                imageSmoothingEnabled: true,
                imageSmoothingQuality: 'high',
                maxWidth: 4096,
                maxHeight: 4096
            });
            base64data = canvas.toDataURL('image/jpeg', 0.92);
            myCropper.replace(base64data);
            myCropper.setDragMode('move');
            imageEditButtons.classList.add('cropped');
            imageEditButtons.querySelector('.clicked').classList.remove('clicked');
            imageEditButtons.querySelector('button[name=move-btn]').classList.add('clicked');
            setTimeout(() => myCropper.clear(), 100);
            break;

        default:
            break;
    }
})

///////////////////////////////////////////////////////
// functions
///////////////////////////////////////////////////////

async function configCamera() {
    try {
        if ('mediaDevices' in navigator && 'getUserMedia' in navigator.mediaDevices) {
            await stopStream();
            const constraints = {
                video: {
                    facingMode: facingMode,
                },
            };
            videoStream = await navigator.mediaDevices.getUserMedia(constraints);
            video.srcObject = videoStream;
            $('#btn_snapshot').prop('disabled', false);
            isCameraOn = true;
            if (usedMask) {
                showMask();
                setTimeout(() => showMask(), 500);
            }
        }
    } catch (err) {
        alert_error("برنامه اجازه دسترسی به دوربین را ندارد.<br/>بعد از تایید دسترسی، مجددا اقدام کنید.");
    }
}

async function stopStream() {
    try {
        if (videoStream && videoStream.getTracks) {
            await videoStream.getTracks().forEach((track) => {
                track.stop();
            });
        }
    } catch (err) {
        alert_error("توقف ویدئو استریم با خطا مواجه شده است" + '<br/>' + err + '<br/>' + err.message);   //  <==========
    }
}

function configCropper() {
    myCropper = new Cropper(imageRepair, {
        /*
        // An object with the previous cropping result data
        data: null,
        // A selector for adding extra containers to preview
        preview: '',
        // Re-render the cropper when resize the window
        responsive: true,
        // Restore the cropped area after resize the window
        restore: true,
        // Check if the current image is a cross-origin image
        checkCrossOrigin: true,
        // Check the current image's Exif Orientation information
        checkOrientation: true,
        // Show the black modal
        modal: true,
        // Show the white modal to highlight the crop box
        highlight: true,
        // Show the grid background
        background: true,
         */
        // The initial aspect ratio of the crop box
        initialAspectRatio: 1,
        // The aspect ratio of the crop box
        aspectRatio: aspectRatio,
        // The view mode of the cropper
        viewMode: 2, // 0, 1, 2, 3
        // The dragging mode of the cropper
        dragMode: 'move', // 'crop', 'move' or 'none'
        // Enable to move the image
        //movable: false,
        // Show the dashed lines for guiding
        guides: false,
        // Show the center indicator for guiding
        center: false,
        // Enable to crop the image automatically when initialize
        autoCrop: true,
        // Define the percentage of automatic cropping area when initializes
        autoCropArea: autoCropArea,
        // Enable to rotate the image
        rotatable: true,
        // Enable to scale the image
        scalable: true,
        // Enable to zoom the image
        zoomable: true,
        // Enable to zoom the image by dragging touch
        zoomOnTouch: false,
        // Enable to zoom the image by wheeling mouse
        zoomOnWheel: true,
        // Define zoom ratio when zoom the image by wheeling mouse
        wheelZoomRatio: 0.1,
        // Enable to move the crop box
        cropBoxMovable: true,
        // Enable to resize the crop box
        cropBoxResizable: true,
        // Toggle drag mode between "crop" and "move" when click twice on the cropper
        toggleDragModeOnDblclick: false,
        /*
        // Size limitation
        minCanvasWidth: 0,
        minCanvasHeight: 0,
        minCropBoxWidth: 0,
        minCropBoxHeight: 0,
        minContainerWidth: 200,
        minContainerHeight: 100,
        // Shortcuts of events
        ready: null,
        cropstart: null,
        cropmove: null,
        cropend: null,
        crop: null,
        zoom: null
     */
    });

    imageEditButtons.querySelector('button[name=crop-btn]').classList.remove('clicked');
    imageEditButtons.querySelector('button[name=move-btn]').classList.add('clicked');

    unwait_();
}

function savingDone(data) {
    myCropper.destroy();
    myCropper = null;
    call_fnc(data);
    close();
}

function showMask() {
    const canvasElement = document.createElement('canvas');
    canvasElement.classList.add('mask_canvas');
    document.getElementById("my_camera").appendChild(canvasElement);
    canvasElement.style.position = 'fixed';
    const ctxm = canvasElement.getContext("2d");
    const w = video.videoWidth;
    const h = video.videoHeight;

    const x = w / 2;
    const y = h / 2;
    const radius = 100;
    canvasElement.width = w;
    canvasElement.height = h;

    ctxm.fillStyle = "rgba(0,0,0,0.5)";
    ctxm.fillRect(0, 0, w, h);                          // fill mask with 50% transp. black
    ctxm.globalCompositeOperation = "destination-out";  // knocks out background
    ctxm.fillStyle = "#000";                            // some solid color
    ctxm.moveTo(x, y);                                  // circle 1
    ctxm.arc(x, y, radius, 0, Math.PI * 2);
    ctxm.fill();                                        // knock em' out, DONE!
}

///////////////////////////////////////////////////////
// dblclick event
///////////////////////////////////////////////////////

const dblclickZoomRatio = 1.2;
let clickCount = 0;
let firstClickTimer;

imageRepair.parentElement.addEventListener('click', (e) => {
    clickCount++;
    if (clickCount == 1) {
        firstClickTimer = setTimeout(() => {
            clickCount = 0;
        }, 400);
    } else if (clickCount == 2) {
        const canvasData = myCropper.getCanvasData();
        const ratio = dblclickZoomRatio * canvasData.width / canvasData.naturalWidth;
        clearTimeout(firstClickTimer);
        clickCount = 0;
        myCropper.zoomTo(ratio, {
            x: e.offsetX,
            y: e.offsetY,
        });
    }
})
