
let clickedBtn = 0;

window.addEventListener('load', (e) => {
    document.querySelectorAll('.camera-crop').forEach((btn) => {
        const usedMask = (btn.hasAttribute('used_mask')) ? btn.getAttribute('used_mask') : 0;
        const minCroppedSize = (btn.hasAttribute('min_cropped_size')) ? btn.getAttribute('min_cropped_size') : 0;
        const aspectRatio = (btn.hasAttribute('aspect_ratio')) ? btn.getAttribute('aspect_ratio') : 0;
        const autoCropArea = (btn.hasAttribute('auto_crop_area')) ? btn.getAttribute('auto_crop_area') : 0;
        const transferData = [];
        if (btn.hasAttribute('output_type')) {
            transferData.push(btn.getAttribute('output_type'));
            transferData.push(usedMask);
            transferData.push(minCroppedSize);
            transferData.push(aspectRatio);
            transferData.push(autoCropArea);

            btn.addEventListener('click', (e) => {
                clickedBtn = e.currentTarget;
                open_form_("page/CameraPhotoCropping/CameraPhotoCropping.aspx", 'برش عکس', transferData.join('&'), 'finishedStorage');
            })

            btn.addEventListener('outputready', (e) => {
                if (receive_output) {
                    const id = e.target.id ? e.target.id : "";
                    receive_output(e.detail, id);
                }
            })
        }
    })
})

function finishedStorage(data) {
    if (clickedBtn) {
        const customEvent = new CustomEvent('outputready', { detail: data });
        clickedBtn.dispatchEvent(customEvent);
        clickedBtn = 0;
    }
}